#include <bits/stdc++.h>
using namespace std;

#define long int64_t
#define endl '\n'

#ifdef OFFLINE
	#define logan(...) logg(#__VA_ARGS__, __VA_ARGS__)
	template<class Arg>
	void logg(const char* name, Arg&& arg){ cerr << name << ": " << arg << '\n'; }
	template<class Arg, class ... Args>
	void logg(const char* name, Arg&& arg, Args&& ... args){
		const char* next = strchr(name+1, ',');
		cerr.write(name, next-name) << ": " << arg << ",";
		logg(next+1, args...);
	}
	#define timeme 1.0*clock()/CLOCKS_PER_SEC
#else
	#define logan(...) {}
	#define timeme {}
#endif

char res[13][13];
basic_string<char> origst[13][13];
int cov[13][13];

int done_n, done_m;
void done(){
	int n = done_n;
	int m = done_m;
	logan(n, m);
	for(int i = 1; i <= n; ++i){
		for(int j = 1; j <= m; ++j)
			cout << res[i][j];
		cout << endl;
	}
	exit(0);
}

void ddone(){
	#ifdef OFFLINE
		int n = done_n;
		int m = done_m;
		for(int i = 1; i <= n; ++i){
			for(int j = 1; j <= m; ++j)
				cerr << res[i][j];
			cerr << ' ';
			for(int j = 1; j <= m; ++j)
				cerr << cov[i][j];
			cerr << endl;
		}
	#endif
}

void fill_blank(int n, int m){
	for(int i = 1; i <= min(n, m); ++i) res[i][i] = 'C';
	done();
}

struct pr{ int a, b; };
int uset(pr t){
	int x = t.a; int y = t.b;
	origst[x][y] += res[x][y];
	if(res[x][y] != '.') return 1;

	if(res[x+1][y] == '0' || res[x-1][y] == '0') return 0;
	if(res[x][y+1] == '0' || res[x][y-1] == '0') return 0;

	res[x][y] = 'C';
	cov[x][y] = 1;
	for(int i = x-1; res[i][y] == '.'; --i) ++cov[i][y];
	for(int i = x+1; res[i][y] == '.'; ++i) ++cov[i][y];
	for(int i = y-1; res[x][i] == '.'; --i) ++cov[x][i];
	for(int i = y+1; res[x][i] == '.'; ++i) ++cov[x][i];
	return 1;
}

void unset(pr t){
	int x = t.a; int y = t.b;

	res[x][y] = origst[x][y].back();
	origst[x][y].pop_back();
	if(res[x][y] != '.') return;

	res[x][y] = '.';
	cov[x][y] = 0;
	for(int i = x-1; res[i][y] == '.'; --i){ --cov[i][y]; }
	for(int i = x+1; res[i][y] == '.'; ++i){ --cov[i][y]; }
	for(int i = y-1; res[x][i] == '.'; --i){ --cov[x][i]; }
	for(int i = y+1; res[x][i] == '.'; ++i){ --cov[x][i]; }
}

#define ISNCOVB(x, y) (res[(x)-1][(y)] >= '0' || res[(x)+1][(y)] >= '0' || res[(x)][(y)-1] >= '0' || res[(x)][(y)+1] >= '0')

void real_verify(){
	/*logan("E");
	#ifdef OFFLINE
		for(int i = 1; i <= done_n; ++i){
			for(int j = 1; j <= done_m; ++j)
				cerr << cov[i][j]; cerr << endl;
		}
	#endif
	ddone();*/

	for(int i = 1; i <= done_n; ++i){
		for(int j = 1; j <= done_m; ++j){
			if(cov[i][j]) continue;
			if(ISNCOVB(i, j)) return;
		}
	}
	done();
}

int sps = 0;
pr st[101];

#define ISFREE(x) (res[(x).a][(x).b] == '.' && !cov[(x).a][(x).b] || res[(x).a][(x).b] == 'C')

void bfs(int pi, int pj){
	logan("BFS", pi, pj);
	ddone();
	for(int i = pi; i <= done_n; ++i){
		for(int j = pj; j <= done_m; ++j){
			int tmp = ISNCOVB(i, j);
			logan(i, j, cov[i][j], tmp);

			#ifdef OFFLINE
				if(pi == 1 && pj == 1 && i == 1 && j == 5){
					ddone();
					logan("AAAAAAAAH", i, j, cov[i][j], tmp);
				}
			#endif

			if(cov[i][j]) continue;
			if(ISNCOVB(i, j)) continue;

			uset({i, j});
			int _i = i;
			int _j = j+1;
			if(_j > done_m) { _j = 1; ++_i; }

			logan("CALLING", _i, _j);
			bfs(_i, _j);
			logan("CALL FAILED", _i, _j);

			unset({i, j});
			ddone();
		}
	}
	real_verify();
}

void dfs(int sp){
	if(sp == sps){
		real_verify();
		bfs(1, 1);
		return;
	}

	int x = st[sp].a, y = st[sp].b;
	pr _l = {x+1, y};
	pr _r = {x-1, y};
	pr _u = {x, y+1};
	pr _d = {x, y-1};
	
	int fr_l = ISFREE(_l);
	int fr_r = ISFREE(_r);
	int fr_u = ISFREE(_u);
	int fr_d = ISFREE(_d);

	switch(res[x][y]){
		case '0': 
			dfs(sp+1);
			break;
		case '1':
			if(fr_l){ uset(_l); dfs(sp+1); unset(_l); }
			if(fr_r){ uset(_r); dfs(sp+1); unset(_r); }
			if(fr_u){ uset(_u); dfs(sp+1); unset(_u); }
			if(fr_d){ uset(_d); dfs(sp+1); unset(_d); }
			break;
		case '2':
			if(fr_l && fr_r) { uset(_l); uset(_r); dfs(sp+1); unset(_l); unset(_r); }
			if(fr_l && fr_d) { uset(_l); uset(_d); dfs(sp+1); unset(_l); unset(_d); }
			if(fr_l && fr_u) { uset(_l); uset(_u); dfs(sp+1); unset(_l); unset(_u); }

			if(fr_r && fr_u) { uset(_r); uset(_u); dfs(sp+1); unset(_r); unset(_u); }
			if(fr_r && fr_d) { uset(_r); uset(_d); dfs(sp+1); unset(_r); unset(_d); }
			if(fr_d && fr_u) { uset(_d); uset(_u); dfs(sp+1); unset(_d); unset(_u); }
		case '3':
			if(fr_l && fr_r && fr_u) { uset(_l); uset(_r); uset(_u); dfs(sp+1); unset(_l); unset(_r); unset(_u); }
			if(fr_l && fr_r && fr_d) { uset(_l); uset(_r); uset(_d); dfs(sp+1); unset(_l); unset(_r); unset(_d); }
			if(fr_l && fr_d && fr_u) { uset(_l); uset(_d); uset(_u); dfs(sp+1); unset(_l); unset(_d); unset(_u); }
			if(fr_r && fr_d && fr_u) { uset(_r); uset(_d); uset(_u); dfs(sp+1); unset(_r); unset(_d); unset(_u); }
			break;
		case '4':
			if(fr_l && fr_r && fr_d && fr_u) {  uset(_l); uset(_r); uset(_u); uset(_d); dfs(sp+1); unset(_l); unset(_r); unset(_u); unset(_d); }
			break;
	}

}


int main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);
	cerr.tie(nullptr);

	int t;
	t = 1;
	for(;t;--t){
		memset(cov, 0, sizeof cov);
		memset(origst, 0, sizeof origst);

		int n, m; cin >> n >> m;
		int nb = 0, sp = 0;
		memset(res, '#', sizeof res);
		for(int i = 1; i <= n; ++i){
			string t; cin >> t;
			for(int j = 1; j <= m; ++j){
				res[i][j] = t[j-1];
				if(t[j-1] != '.') { ++nb; cov[i][j] = 1; }
				if(t[j-1] >= '0') st[sp++] = {i, j};
			}
		}
		done_n = n;
		done_m = m;
		if(!nb) fill_blank(n, m);

		#ifdef OFFLINE
			//for(int i = 1; i <= n; ++i){
				//for(int j = 1; j <= m; ++j)
					//cerr << cov[i][j]; cerr << endl;
			//}
		#endif

		if(sp == 0) bfs(1, 1);

		sps = sp;
		dfs(0);
		cout << -1 << endl;
	}
}

// Ja dok sam ovo radio https://www.youtube.com/watch?v=U5jNeE7aT0M