#include <bits/stdc++.h>
#define f first
#define s second
#define pb push_back
#define mp make_pair

using namespace std;
typedef long long ll;
typedef pair<ll, ll> pll;

ll n, m;
ll a[100000];

ll tree[300000] = {0}; // cuvamo broj obojenih
ll lazy[300000] = {0};

void lazyCheck(ll node, ll start, ll end)
{
	if(lazy[node] != 0)
    {
        tree[node] += (end - start + 1) * lazy[node];
        if(start != end)
        {
            lazy[node*2] += lazy[node];
            lazy[node*2+1] += lazy[node];
        }
        lazy[node] = 0;
    }
}

void update(ll node, ll start, ll end, ll i, ll j, ll delta)
{
	lazyCheck(node, start, end);
	if(i > end || j < start || start > end)
	{
		return;
	}
	else if(i <= start && end <= j)
	{
		tree[node] += (end - start + 1) * delta;
		if(start != end)
		{
			lazy[2*node] += delta;
			lazy[2*node+1] += delta;
		}
	}
	else
	{
		ll mid = (start + end) / 2;
		update(2*node, start, mid, i, j, delta);
		update(2*node+1, mid+1, end, i, j, delta);
		tree[node] = tree[2*node] + tree[2*node + 1];
	}
}

ll query(ll node, ll start, ll end, ll i, ll j)
{
	if(i > end || j < start || start > end)
	{
		return 0;
	}
	lazyCheck(node, start, end);
	if(i <= start && end <= j)
	{
		return tree[node];
	}
	else
	{
		ll mid = (start + end) / 2;
		ll left = query(2*node, start, mid, i, j);
		ll right = query(2*node+1, mid+1, end, i, j);
		return left + right;
	}
}

ll eval()
{
	ll rez = 0;
	for(ll i = 1; i <= m; i++)
	{
		ll v = query(1, 0, m, i, i);
		rez += v * (n - v);
	}
	return rez;
}

int main()
{
	ll t = 1;
	//freopen("in.txt", "r", stdin);
	//freopen("out2.txt", "w", stdout);
	ios::sync_with_stdio(false);
	cin.tie(0);
	cin >> n >> m;
	while(t--)
	{	
		memset(tree, 0, sizeof(tree));
		memset(lazy, 0, sizeof(lazy));
		for(ll i = 0; i < n; i++) cin >> a[i];
		sort(a, a+n);
	
		for(ll i = 0; i < n; i++)
			update(1, 0, m, a[i]+1, m, 1);
	
		ll val =  eval();
		ll minval = val;
	
		for(ll i = 0; i < n; i++) // i-ti flipujemo
		{
			ll d1 = 2*query(1, 0, m, a[i]+1, m) - (m - a[i])*(n+1);
			ll d2 = a[i] * (n-1) - 2*query(1, 0, m, 1, a[i]);
			update(1, 0, m, 1, a[i], 1);
			update(1, 0, m, a[i]+1, m, -1);
			val += (d1 + d2);		
			minval = min(minval, val);
		}	
		cout << minval;
	}
	return 0;
}