#include <iostream>
#include <set>
#include <utility>
#include <cstdlib>

using namespace std;

enum polje
{
nula = 0, jedan = 1, dva = 2, tri = 3, cetiri = 4, zid, prazno, top
};

struct kocka
{
	int i, j, broj;
	kocka()
	{
	}
	kocka(int i, int j, int broj)
	{
		this->i = i;
		this->j = j;
		this->broj = broj;
	}
	kocka(int i, int j)
	{
		this->i = i;
		this->j = j;
	}
};

static inline bool operator==(const kocka a, const kocka b)
{
	return a.i == b.i && a.j == b.j;
}

static inline bool operator<(const kocka a, const kocka b)
{
	return a.i < b.i || (a.i == b.i && a.j < b.j);
}

static polje tabla[10][10];
static int n, m;
static set<pair<int, int>> cetvorke, nule, inicijalno_slobodni, inicjalno_potrebni;
static set<kocka> brojevi;

template<typename T> static inline set<T> operator+(const set<T> a, const set<T> b)
{
	set<T> rezultat;
	for (T element : a)
		rezultat.insert(element);
	for (T element : b)
		rezultat.insert(element);
	return rezultat;
}

template<typename T> static inline set<T> operator-(const set<T> a, const set<T> b)
{
	set<T> rezultat = a;
	for (T element : b)
		rezultat.erase(element);
	return rezultat;
}

template<typename T> static inline set<T> operator-=(set<T>& a, const set<T> b)
{
	for (T element : b)
		a.erase(element);
	return b;
}

static inline pair<bool, kocka> pomocna_funkcija(int i, int j, set<kocka>& b)
{
	kocka ovo(i, j);
	auto broj = b.find(ovo);
	if (broj == b.end())
		return make_pair(false, ovo);
	ovo = *broj;
	b.erase(broj);
	if (broj->broj == 1)
		return make_pair(true, *broj);
	ovo.broj--;
	b.insert(ovo);
	return make_pair(false, ovo);
}

static inline pair<int, int> upari(kocka a)
{
	return make_pair(a.i, a.j);
}

static inline void pomocna_funkcija2(kocka broj, set<pair<int, int>>& slobodni, set<kocka>& b)
{
	b.erase(broj);
	int i = broj.i, j = broj.j;
	slobodni.erase(make_pair(i - 1, j));
	slobodni.erase(make_pair(i + 1, j));
	slobodni.erase(make_pair(i, j + 1));
	slobodni.erase(make_pair(i, j - 1));
}

static inline set<pair<int, int>> postavi_top(int i, int j, set<kocka>& b, set<pair<int, int>>& slobodni)
{
	tabla[i][j] = top;
	set<pair<int, int>> pogodjeni;
	auto a = pomocna_funkcija(i - 1, j, b);
	if (a.first)
		pomocna_funkcija2(a.second, slobodni, b);
	a = pomocna_funkcija(i + 1, j, b);
	if (a.first)
		pomocna_funkcija2(a.second, slobodni, b);
	a = pomocna_funkcija(i, j + 1, b);
	if (a.first)
		pomocna_funkcija2(a.second, slobodni, b);
	a = pomocna_funkcija(i, j - 1, b);
	if (a.first)
		pomocna_funkcija2(a.second, slobodni, b);
	pogodjeni.insert(make_pair(i, j));
	for (int ii = i - 1; i >= 0 && tabla[ii][j] == prazno; ii--)
		pogodjeni.insert(make_pair(ii, j));
	for (int ii = i + 1; i < n && tabla[ii][j] == prazno; ii++)
		pogodjeni.insert(make_pair(ii, j));
	for (int jj = j - 1; j >= 0 && tabla[i][jj] == prazno; jj--)
		pogodjeni.insert(make_pair(i, jj));
	for (int jj = j + 1; j < m && tabla[i][jj] == prazno; jj++)
		pogodjeni.insert(make_pair(i, jj));
	return pogodjeni;
}

static inline bool ne_sadrzi(set<pair<int, int>> slobodni, int i, int j)
{
	return slobodni.find(make_pair(i, j)) != slobodni.end();
}

static inline bool sadrzi(set<pair<int, int>> slobodni, int i, int j)
{
	return slobodni.find(make_pair(i, j)) == slobodni.end();
}

static inline void resi_zadatak(set<pair<int, int>> slobodni, set<pair<int, int>> potrebni, set<kocka> nepotpuni_brojevi);

static inline void pokusaj(int i, int j, set<pair<int, int>> slobodni, set<pair<int, int>> potrebni, set<kocka> nepotpuni_brojevi)
{
	if (i < 0 || i >= n || j < 0 || j >= m || slobodni.find(make_pair(i, j)) == slobodni.end())
		return;
	set<pair<int, int>> novi_slobodni = slobodni;
	set<pair<int, int>> novi_potrebni = potrebni;
	set<kocka> novi_nepotpuni_brojevi = nepotpuni_brojevi;
	novi_potrebni -= novi_slobodni -= postavi_top(i, j, novi_nepotpuni_brojevi, novi_slobodni);
	resi_zadatak(novi_slobodni, novi_potrebni, novi_nepotpuni_brojevi);
	tabla[i][j] = prazno;
}

static inline void resi_zadatak(set<pair<int, int>> slobodni, set<pair<int, int>> potrebni, set<kocka> nepotpuni_brojevi)
{
	if (potrebni.empty() && nepotpuni_brojevi.empty())
	{
		for (int i = 0; i < n; i++)
		{
			for (int j = 0; j < m; j++)
				switch (tabla[i][j])
				{
					case prazno:
						cout << '.';
						break;
					case zid:
						cout << '#';
						break;
					case top:
						cout << 'C';
						break;
					default:
						cout << tabla[i][j];
				}
			cout << '\n';
		}
		exit(0);
	}
	if (slobodni.empty())
		return;
	for (auto broj : nepotpuni_brojevi)
	{
		int i = broj.i, j = broj.j;
		pokusaj(i - 1, j, slobodni, potrebni, nepotpuni_brojevi);
		pokusaj(i + 1, j, slobodni, potrebni, nepotpuni_brojevi);
		pokusaj(i, j - 1, slobodni, potrebni, nepotpuni_brojevi);
		pokusaj(i, j + 1, slobodni, potrebni, nepotpuni_brojevi);
		return;
	}
	for (auto slobodan : slobodni)
		pokusaj(slobodan.first, slobodan.second, slobodni, potrebni, nepotpuni_brojevi);
}

int main()
{
	ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
	cin >> n >> m;
	for (int i = 0; i < n; i++)
	{
		string linija;
		cin >> linija;
		for (int j = 0; j < m; j++)
			switch (linija[j])
			{
				case '.':
					tabla[i][j] = prazno;
					inicijalno_slobodni.insert(make_pair(i, j));
					break;
				case '#':
					tabla[i][j] = zid;
					break;
				case '4':
					cetvorke.insert(make_pair(i, j));
					tabla[i][j] = cetiri;
					break;
				case '0':
					nule.insert(make_pair(i, j));
					tabla[i][j] = nula;
					break;
				default:
					auto ovo = (polje)(linija[j] - (char)'0');
					tabla[i][j] = ovo;
					kocka a(i, j, ovo);
					brojevi.insert(a);
			}
	}
	inicjalno_potrebni = inicijalno_slobodni;
	for (auto cetvorka : cetvorke)
	{
		int i = cetvorka.first, j = cetvorka.second;
		if ((i != 0 || ne_sadrzi(inicijalno_slobodni, i - 1, j)) ||
			(i != n || ne_sadrzi(inicijalno_slobodni, i + 1, j)) ||
			(j != 0 || ne_sadrzi(inicijalno_slobodni, i, j - 1)) ||
			(j != m || ne_sadrzi(inicijalno_slobodni, i, j + 1)))
			goto kraj;
		inicjalno_potrebni -= inicijalno_slobodni -= postavi_top(i - 1, j, brojevi, inicijalno_slobodni) +
		                                            postavi_top(i + 1, j, brojevi, inicijalno_slobodni) +
		                                            postavi_top(i, j - 1, brojevi, inicijalno_slobodni) +
		                                            postavi_top(i, j + 1, brojevi, inicijalno_slobodni);
	}
	for (auto nula : nule)
	{
		int i = nula.first, j = nula.second;
		if (i != 0)
			inicijalno_slobodni.erase(make_pair(i - 1, j));
		if (i != n)
			inicijalno_slobodni.erase(make_pair(i + 1, j));
		if (j != 0)
			inicijalno_slobodni.erase(make_pair(i, j - 1));
		if (j != m)
			inicijalno_slobodni.erase(make_pair(i, j + 1));
	}
	resi_zadatak(inicijalno_slobodni, inicjalno_potrebni, brojevi);
	kraj:
	cout << "-1";
}