#include <bits/stdc++.h>
#define debug(x) cout << #x << " is " << x << '\n';
#define stigao() cout << "Stigao" << '\n';
#define file() freopen("output.txt", "w", stdout);

#define x first
#define y second

using namespace std;

vector< pair<int, int> > p, d;
char mat[15][15];
bool isCoveredPoint[15][15];
int n, m, cntPoint;

bool isValidNumber(){
    int cnt = 0, i, j;
    for(auto k : d){
        cnt = 0;
        i = k.x;
        j = k.y;
        if(i > 0 && mat[i - 1][j] == 'C') cnt++;
        if(i < n - 1 && mat[i + 1][j] == 'C') cnt++;
        if(j > 0 && mat[i][j - 1] == 'C') cnt++;
        if(j < m - 1 && mat[i][j + 1] == 'C') cnt++;

        if(cnt != (mat[i][j] - '0'))
            return false;
    }

    return true;
}


bool isValidPlaced(){
    memset(isCoveredPoint, 0, sizeof(isCoveredPoint));
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            isCoveredPoint[i][j] = mat[i][j] != '.';
        }
    }

    for(auto c : p){
        if(mat[c.x][c.y] == 'C'){
            for(int k = c.x + 1; k < n; k++){
                if(mat[k][c.y] == '.')
                    isCoveredPoint[k][c.y] = true;
                else if(mat[k][c.y] == 'C')
                    return false;
                else
                    break;
            }
            for(int k = c.x - 1; k >= 0; k--){
                if(mat[k][c.y] == '.')
                    isCoveredPoint[k][c.y] = true;
                else if(mat[k][c.y] == 'C')
                    return false;
                else
                    break;

            }
            for(int k = c.y + 1; k < m; k++){
                if(mat[c.x][k] == '.')
                    isCoveredPoint[c.x][k] = true;
                else if(mat[c.x][k] == 'C')
                    return false;
                else
                    break;

            }
            for(int k = c.y - 1; k >= 0; k--){
                if(mat[c.x][k] == '.')
                    isCoveredPoint[c.x][k] = true;
                else if(mat[c.x][k] == 'C')
                    return false;
                else
                    break;
            }
        }
    }

    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            if(!isCoveredPoint[i][j])
                return false;
        }
    }
    return true;
}

bool canPlace(int iter, bool isPoint = true){
    pair<int, int> c;
    if(isPoint)
        c = p[iter];
    else
        c = d[iter];
    if(mat[c.x][c.y] == 'C')
        return false;
    for(int k = c.x + 1; k < n; k++){
        if(mat[k][c.y] == 'C')
            return false;
        else
            break;
    }
    for(int k = c.x - 1; k >= 0; k--){
        if(mat[k][c.y] == 'C')
            return false;
        else
            break;

    }
    for(int k = c.y + 1; k < m; k++){
        if(mat[c.x][k] == 'C')
            return false;
        else
            break;

    }
    for(int k = c.y - 1; k >= 0; k--){
        if(mat[c.x][k] == 'C')
            return false;
        else
            break;
    }

    return true;
}

bool solve(int iter){
    if(iter == cntPoint){
        return isValidNumber() && isValidPlaced();
    }
    if(solve(iter + 1))
        return true;
    if(canPlace(iter)){
        mat[p[iter].x][p[iter].y] = 'C';
        if(solve(iter + 1))
            return true;
        mat[p[iter].x][p[iter].y] = '.';
    }
    return false;
}

int cntNumber;
bool number_solve(int iter){
    if(iter == cntNumber){
        if(isValidNumber() && isValidPlaced())
            return true;
        else {
            return solve(0);
        }
    }

    int i, j;
    int cnt = 0;
    i = d[iter].x;
    j = d[iter].y;
    if(mat[i][j] - '0' == 0){
        if(number_solve(iter + 1))
            return true;
        return false;
    }

    vector< pair<int, int> > pos;
    if(i > 0){
        if(mat[i - 1][j] == '.'){
            pos.push_back({i - 1, j});
            cnt++;
        } else if(mat[i - 1][j] == 'C') {
            cnt--;
        }
    }
    if(i < n - 1){
        if(mat[i + 1][j] == '.'){
            pos.push_back({i + 1, j});
            cnt++;
        } else if(mat[i + 1][j] == 'C'){
            cnt--;
        }
    }
    if(j > 0){
        if(mat[i][j - 1] == '.'){
            pos.push_back({i, j - 1});
            cnt++;
        } else if(mat[i][j - 1] == 'C'){
            cnt--;
        }
    }
    if(j < m - 1){
        if(mat[i][j + 1] == '.'){
            pos.push_back({i, j + 1});
            cnt++;
        } else if(mat[i][j + 1] == 'C'){
            cnt--;
        }
    }

    int cntPos = pos.size();
    if(mat[i][j] - '0' != 4){
        for(int k = 0; k < cntPos; k++){
            for(int s = 0; s < cntPos; s++){
                if(mat[i][j] - '0' > s){
                    if(canPlace(iter, false))
                        mat[pos[(k + s) % cntPos].x][pos[(k + s) % cntPos].y] = 'C';
                }
            }
            if(number_solve(iter + 1))
                return true;
            for(int s = 0; s < cntPos; s++){
                 if(mat[i][j] - '0' > s)
                    mat[pos[(k + s) % cntPos].x][pos[(k + s) % cntPos].y] = '.';
            }
        }
    } else if(mat[i][j] - '0' == 4){
        mat[i - 1][j] = 'C';
        mat[i + 1][j] = 'C';
        mat[i][j - 1] = 'C';
        mat[i][j + 1] = 'C';
        if(number_solve(iter + 1))
            return true;
        mat[i - 1][j] = '.';
        mat[i + 1][j] = '.';
        mat[i][j - 1] = '.';
        mat[i][j + 1] = '.';
        return false;
    }
    return false;
}

int main() {
    ios::sync_with_stdio(0), cin.tie(0), cout.tie(0);
    cin >> n >> m;
    bool isEmpty = true, solved = false;
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            cin >> mat[i][j];
            if(mat[i][j] == '.'){
                p.push_back({i, j});
            } else {
                isEmpty = false;
                if(mat[i][j] >= '0' && mat[i][j] <= '4')
                    d.push_back({i, j});
            }
        }
    }
    if(isEmpty){
        int larger = max(n, m);
        for(int i = 0; i < larger; i++)
            mat[i][i] = 'C';
        solved = true;
    } else {
        cntPoint = p.size();
        cntNumber = d.size();
        if(cntPoint > 45){
            solved = false;
        } else if(cntNumber > 0)
            solved = number_solve(0);
        else
            solved = solve(0);
    }
    if(solved){
        for(int i = 0; i < n; i++){
            for(int j = 0; j < m; j++){
                cout << mat[i][j];
            }
            cout << '\n';
        }
    } else {
        cout << -1;
    }

    return 0;
}