#include<iostream>

using namespace std;

struct Predmet{
    long int tezina;
    long int vrednost;
};


void swap(long int *i, long int *j){
    int temp = *i;
    *i = *j;
    *j = temp;
}

int partition(long int arr[], int low, int high){
    long int pivot = arr[high];
    int i = low - 1;
    
    for(int j = low; j <= high - 1; j++){
        if(arr[j] <= pivot){
            i++;
            swap(&arr[i], &arr[j]);
        }
    }
    swap(&arr[i+1], &arr[high]);
    return (i+1);
}

void sort(long int arr[], int low, int high){
    if(low < high){
        int pi = partition(arr, low, high);
        
        sort(arr, low, pi-1);
        sort(arr, pi+1, high);
    }
}

void swapPredmet(Predmet *i, Predmet *j){
    Predmet temp = *i;
    *i = *j;
    *j = temp;
}

int partitionPredmet(Predmet arr[], int low, int high){
    long int pivot = arr[high].tezina;
    int i = low - 1;
    
    for(int j = low; j <= high - 1; j++){
        if(arr[j].tezina <= pivot){
            i++;
            swapPredmet(&arr[i], &arr[j]);
        }
    }
    swapPredmet(&arr[i+1], &arr[high]);
    return (i+1);
}

void sortPredmet(Predmet arr[], int low, int high){
    if(low < high){
        int pi = partitionPredmet(arr, low, high);
        
        sortPredmet(arr, low, pi-1);
        sortPredmet(arr, pi+1, high);
    }
}

int main(){
    int M, N;
    long int ukupnaVrednost = 0;
    cin >> M >> N;
    Predmet  predmet[M];
    bool     zauzetPredmet[M] = {false};
    long int kutija[N];
    
    for(int i = 0; i < M; i++) cin >> predmet[i].tezina;
    for(int i = 0; i < M; i++) cin >> predmet[i].vrednost;
    for(int i = 0; i < N; i++) cin >> kutija[i];
    
    
    sort(kutija, 0, N-1);
    sortPredmet(predmet, 0, M-1);
    
    for(int i = 0; i < N; i++){
        int j = 0;
        bool flag = false;
        int index;
        while((predmet[j].tezina < kutija[i]) && (j < M)){
            if(!zauzetPredmet[j]){
                if(!flag){
                    flag = true;
                    index = j;
                } else {
                    if(predmet[j].vrednost > predmet[index].vrednost) index = j;
                }
            }
            j++;
        }
        ukupnaVrednost+= predmet[index].vrednost;
        zauzetPredmet[index] = true;
    }
    
    cout << ukupnaVrednost;
    return 0;    
}