#include <iostream>
#include <vector>
#include <algorithm>
#include <string>

using namespace std;

std::vector<int> GetInput()
{
	std::vector<int> input;
	int a;

	while (std::cin >> a)
	{
		input.push_back(a);

		if (cin.peek() == '\n')
		{
			break;
		}
	}

	return input;
}

bool Compare(pair<int, int> element1, pair<int, int> element2)
{
	if (element1.first < element2.first)
	{
		return false;
	}
	else if (element1.first > element2.first)
	{
		return true;
	}

	return element1.second < element2.second;
}

int GetBestElement(int capacity, vector<pair<int, int>> things)
{
	for (int i = 0; i < things.size(); ++i)
	{
		if (capacity >= things[i].second)
			return i;
	}

	return -1;
}

int main()
{
	int M;
	int N;

	cin >> M >> N;

	vector<int> weight = GetInput();
	vector<int> value = GetInput();
	vector<int> capacity = GetInput();

	sort(capacity.begin(), capacity.end());

	vector<pair<int, int>> things;
	for (int i = 0; i < M; ++i)
	{
		pair<int, int> p;
		p.first = value[i];
		p.second = weight[i];
		things.push_back(p);
	}

	sort(things.begin(), things.end(), Compare);

	unsigned long long sum = 0;
	int chosen = -1;
	for (int i = 0; i < N; ++i)
	{
		chosen = GetBestElement(capacity[i], things);

		if (chosen != -1)
		{
			sum += things[chosen].first;
			things.erase(things.begin() + chosen);
		}
	}

	cout << sum << endl;

	return 0;
}