#include <bits/stdc++.h>
using namespace std;

const int mx = 1e5+5;
int n, m, ans[mx];

struct Point {
    int x, y;
};

struct Line {
    Point A, B;
} line[mx];

struct Circle {
    Point O;
    double r;
} circle[mx];

Line toLine(int x, int y, int a, int b) {
    Line ret;
    ret.A.x = x; ret.A.y = y;
    ret.B.x = a; ret.B.y = b;
    return ret;
}

Circle toCircle(int x, int y, int r) {
    Circle ret;
    ret.O.x = x;
    ret.O.y = y;
    ret.r = (double)r;
    return ret;
}

double pointDist(Point A, Point B) {
    return sqrt(1.0*(A.x-B.x)*(A.x-B.x) + 1.0*(A.y-B.y)*(A.y-B.y));
}

double vp(Point A, Point B, Point C) {
    return abs(1.0*(A.x-C.x)*(B.y-C.y) - 1.0*(B.x-C.x)*(A.y-C.y));
}

double dist(Point A, Line a) {
    return vp(a.A, a.B, A) / pointDist(a.A, a.B);
}

bool intersect(Line p, Circle k) {
    return dist(k.O, p) <= k.r;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr); cout.tie(nullptr);

    cin >> n;
    for (int i = 1; i <= n; i++) {
        int x, y, a, b;
        cin >> x >> y >> a >> b;
        line[i] = toLine(x, y, a, b);
    }
    cin >> m;
    for (int i = 1; i <= m; i++) {
        int x, y, r;
        cin >> x >> y >> r;
        circle[i] = toCircle(x, y, r);
    }

    for (int i = 1; i <= n; i++) {
        if (!intersect(line[i], circle[m])) continue;
        int l = 1, r = m;
        while (l < r) {
            int mid = (l+r)/2;
            if (intersect(line[i], circle[mid]))
                r = mid;
            else
                l = mid+1;
        }
        ans[l]++;
    }

    for (int i = 1; i <= m; i++) {
        ans[i] += ans[i-1];
        cout << ans[i] << '\n';
    }
}