using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace C_Pakovanje
{
    class Predmet : IComparable
    {
        int tezina, vrednost;
        public Predmet(int tezina, int vrednost)
        {
            this.tezina = tezina;
            this.vrednost = vrednost;
        }
        public int Tezina
        { get { return tezina; } }
        public int Vrednost
        { get { return vrednost; } }
        public int CompareTo(object obj)
        {
            Predmet p = (Predmet)obj;
            if (this.vrednost > p.vrednost || (this.vrednost == p.vrednost && this.tezina < p.tezina)) return -1;
            else if (this.vrednost < p.vrednost || (this.vrednost == p.vrednost && this.tezina > p.tezina)) return 1;
            else return 0;
        }
    }
    class Program
    {
        static void Main(string[] args)
        {
            string[] r = Console.ReadLine().Split(' ');
            int m = int.Parse(r[0]); //br predmeta
            int n = int.Parse(r[1]); //br kutija
            Predmet[] p = new Predmet[m];
            int[] nosivost = new int[n];
            string[] t = Console.ReadLine().Split(' ');
            string[] v = Console.ReadLine().Split(' ');
            int maxTezina = int.MinValue;
            bool sveVrednostiJednake = true;
            for (int i = 0; i < m; i++)
            {
                int tez = int.Parse(t[i]);
                int vred = int.Parse(v[i]);
                if (i > 0 && vred != int.Parse(v[i - 1])) sveVrednostiJednake = false;
                p[i] = new Predmet(tez, vred);
                if (tez > maxTezina) maxTezina = tez;
            }
            Array.Sort(p);
            string[] c = Console.ReadLine().Split(' ');
            int minNosivost = int.MaxValue;
            for (int i = 0; i < n; i++)
            {
                nosivost[i] = int.Parse(c[i]);
                if (nosivost[i] < minNosivost) minNosivost = nosivost[i];
            }
            Array.Sort(nosivost);
            long suma = 0;
            if (maxTezina < minNosivost) //subtask 3
            {
                for (int i = 0; i < n; i++)
                {
                    if (i < m) suma += p[i].Vrednost;
                }
            }
            else if (sveVrednostiJednake) //subtask 4
            {
                int j = 0;
                for (int i = 0; i < n; i++)
                {
                    if (j < m && p[j].Tezina < nosivost[i]) 
                    {
                        suma += p[j].Vrednost;
                        j++;
                    }
                }
            }
            else //subtasks 1 2
            {
                for (int i = 0; i < m; i++)
                {
                    for (int j = 0; j < n; j++)
                    {
                        if (p[i].Tezina < nosivost[j])
                        {
                            suma += p[i].Vrednost;
                            nosivost[j] = 0;
                            break;
                        }
                    }
                }
            }
            Console.WriteLine(suma);
        }
    }
}