using System;
using System.Collections.Generic;

namespace takkvalifikacije
{
    static class Program
    {
        struct Line
        {
            public static Line Input()
            {
                string[] spl = Console.ReadLine().Split(' ');
                Line ret = new Line()
                {
                    x1 = int.Parse(spl[0]),
                    y1 = int.Parse(spl[1]),
                    x2 = int.Parse(spl[2]),
                    y2 = int.Parse(spl[3]),
                    marked = false
                };
                return ret;
            }
            public int x1, y1, x2, y2;
            public bool marked;
        }
        struct Circle
        {
            public static Circle Input()
            {
                string[] spl = Console.ReadLine().Split(' ');
                Circle ret = new Circle()
                {
                    x = int.Parse(spl[0]),
                    y = int.Parse(spl[1]),
                    r = int.Parse(spl[2])
                };
                return ret;
            }
            public int x, y, r;
        }
        static bool intersects(Line line, Circle circle)
        {
            int y = line.y2 - line.y1;
            int x = line.x2 - line.x1;
            long determinant = line.x2 * line.y1 - line.y2 * line.x1;
            long denominator = y * circle.x - x * circle.y + determinant;
            long d = y * y + x * x;
            return denominator * denominator / d <= circle.r * circle.r;
        }
        static void Main()
        {
            int N = int.Parse(Console.ReadLine());
            Line[] kablovi = new Line[N];
            for (int i = 0; i < N; i++)
                kablovi[i] = Line.Input();
            int Q = int.Parse(Console.ReadLine());
            Circle[] scenario = new Circle[Q];
            for (int i = 0; i < Q; i++)
                scenario[i] = Circle.Input();

            List<Line> neosteceniKablovi = new List<Line>(kablovi);
            int osteceniKablovi = 0;
            for (int i = 0; i < Q; i++)
            {
                for (int j = 0, l = neosteceniKablovi.Count; j < l; j++)
                    if (intersects(neosteceniKablovi[j], scenario[i]))
                    {
                        neosteceniKablovi.RemoveAt(j);
                        osteceniKablovi++; j--; l--;
                    }
                Console.WriteLine(osteceniKablovi);
            }
            Console.ReadKey();
        }
    }
}