#include <bits/stdc++.h>
using namespace std;

struct point
{
    double x,y;
};

struct line
{
    bool retarded=0;
    double x;
    double a,b;
};

struct circle
{
    point o;
    double r;
};

line make_line(point a,point b)
{
    line ret;
    if(a.x==b.x)
    {
        ret.retarded=1;
        ret.x=a.x;
        return ret;
    }
    ret.a=(b.y-a.y)/(b.x-a.x);
    ret.b=a.y-a.x*ret.a;
    return ret;
}

double dist(point a,point b)
{
    return sqrt((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y));
}

bool intersect(circle c,line l)
{
    if(l.retarded)
    {
        return abs(c.o.x-l.x)<=c.r;
    }
    if(l.a==0)
    {
        return abs(c.o.y-l.b)<=c.r;
    }
    line temp;
    temp.a=-1.0/l.a;
    temp.b=c.o.y-c.o.x*temp.a;
    point tmp2;
    tmp2.x=(temp.b-l.b)/(l.a-temp.a);
    tmp2.y=temp.a*tmp2.x+temp.b;
    return dist(tmp2,c.o)<=c.r;
}

int n,q;
point in1,in2;
circle in3;
vector<line> lines;
vector<circle> circles;
vector<int> v;

int first_circle(line a)
{
    int l=0,r=q-1;
    while(l<r)
    {
        int mid=(l+r)/2;
        if(intersect(circles[mid],a))
        {
            r=mid;
        }
        else
        {
            l=mid+1;
        }
    }
    if(l==q-1 && !intersect(circles[q-1],a))
    {
        return q;
    }
    return l;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);cout.tie(0);
    cin>>n;
    for(int i=0;i<n;i++)
    {
        cin>>in1.x>>in1.y>>in2.x>>in2.y;
        lines.push_back(make_line(in1,in2));
    }
    cin>>q;
    for(int i=0;i<q;i++)
    {
        cin>>in3.o.x>>in3.o.y>>in3.r;
        circles.push_back(in3);
    }
    for(int i=0;i<n;i++)
    {
        v.push_back(first_circle(lines[i]));
        //printf("%d\n",v.back());
    }
    sort(v.begin(),v.end());
    int cnt=0,idx=0;
    for(int i=0;i<q;i++)
    {
        for(;idx<v.size() && v[idx]<=i;idx++)
        {
            cnt++;
        }
        cout<<cnt<<"\n";
    }
}