#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

#define PB push_back
#define MP make_pair
#define F first
#define S second

int n, q;

struct Point{
    ll x, y;
};

struct Circle{
    ll x, y, rad; // radius
};

typedef pair<Point, Point> pp;
typedef vector<pp> vpp;
typedef vector<Circle> vc;

vpp cables;
vc circles;

void input(){
    scanf("%d", &n);
    Point cur_A, cur_B;
    for(int i = 0; i < n; i++){
        scanf("%lld %lld %lld %lld", &cur_A.x, &cur_A.y, &cur_B.x, &cur_B.y);
        cables.PB(MP(cur_A, cur_B));
    }
    scanf("%d", &q);
    Circle cur_C;
    for(int i = 0; i < q; i++){
        scanf("%lld %lld %lld", &cur_C.x, &cur_C.y, &cur_C.rad);
        circles.PB(cur_C);
    }
}

int getIntersections(Circle circle){
    int out = 0;
    for(auto it = cables.begin(); it != cables.end();){
        Point A, B;
        A = (*it).F; B = (*it).S;

        double height = abs((B.y - A.y)*circle.x - (B.x - A.x)*circle.y + B.x*A.y - B.y*A.x);
        height /= sqrt(pow(B.y - A.y, 2) + pow(B.x - A.x, 2));

        if(circle.rad >= height){
            out++;
            it = cables.erase(it);
        } else {
            it++;
        }
    }
    return out;
}

void Solve(){
    int cur_res = 0;
    for(int i = 0; i < q; i++){
        cur_res += getIntersections(circles[i]);
        printf("%d\n", cur_res);
    }
}

int main()
{
    input();
    Solve();

    return 0;
}