using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Pakovanje2
{
    class Program
    {
        static void Main(string[] args)
        {
            string input = Console.ReadLine();
            int index = input.IndexOf(" ");
            int m = int.Parse(input.Substring(0, index));
            int n = int.Parse(input.Substring(index + 1));
            Predmet[] predmeti = GetPredmeti(m);
            Kutija[] kutije = GetKutijas(n);
            Console.WriteLine(GetMaxValue(predmeti, kutije, m, n));
            Console.ReadLine();
        }

        static double GetMaxValue(Predmet[] predmeti, Kutija[] kutije, int brojPredmeta, int brojKutija)
        {
            MaxPredmet max = new MaxPredmet(predmeti[0]);
            int ind = 1;
            double zbirVrednosti = 0;
            for (int i = 0; i < brojKutija; i++)
            {
                while (ind < brojPredmeta && predmeti[ind].weight <= kutije[i].weight)
                {
                    if (max != null)
                    {
                        if (predmeti[ind].value > max.GetPredmet().value)
                        {
                            max = new MaxPredmet(predmeti[ind], max);
                        }
                        else
                        {
                            MaxPredmet najblizi = max;
                            bool proso = false;
                            while (!proso)
                            {
                                if (najblizi.GetNajblizi() != null)
                                {
                                    if (najblizi.GetNajblizi().GetPredmet().value < predmeti[ind].value)
                                    {
                                        najblizi.SetNajblizi(predmeti[ind]);
                                        proso = true;
                                    }
                                    else
                                    {
                                        najblizi = najblizi.GetNajblizi();
                                    }
                                }
                                else
                                {
                                    najblizi.SetNajblizi(predmeti[ind]);
                                    proso = true;
                                }
                            }
                        }
                        ++ind;
                    }
                    else max = new MaxPredmet(predmeti[ind]);
                }
                if(max!=null) zbirVrednosti += max.GetPredmet().value;
                if (max.GetNajblizi() != null) max = max.GetNajblizi();
                else max = null;
            }
            return zbirVrednosti;            
        }

        static Predmet[] SortPredmeti(Predmet[] predmeti, int startIndex, int endIndex)
        {            
            Predmet[] outPredmet = new Predmet[endIndex - startIndex + 1];
            if (endIndex - startIndex != 0)
            {
                Predmet[] levo = SortPredmeti(predmeti, startIndex, (endIndex + startIndex) / 2);
                Predmet[] desno = SortPredmeti(predmeti, ((endIndex + startIndex) / 2) + 1, endIndex);

                int li = 0, di = 0, ln = levo.Length, dn = desno.Length;
                int index = 0;
                while (li < ln && di < dn)
                {
                    if (levo[li].weight < desno[di].weight) outPredmet[index++] = levo[li++];
                    else outPredmet[index++] = desno[di++];
                }
                while (li < ln)
                {
                    outPredmet[index++] = levo[li++];
                }
                while (di < dn)
                {
                    outPredmet[index++] = desno[di++];
                }
            }
            else outPredmet[0] = predmeti[startIndex];
            return outPredmet;
        }

        static Kutija[] SortKutija(Kutija[] kutije, int startIndex, int endIndex)
        {
            Kutija[] outKutija = new Kutija[endIndex - startIndex + 1];
            if (endIndex - startIndex != 0)
            {
                Kutija[] levo = SortKutija(kutije, startIndex, (endIndex + startIndex) / 2);
                Kutija[] desno = SortKutija(kutije, ((endIndex + startIndex) / 2) + 1, endIndex);

                int li = 0, di = 0, ln = levo.Length, dn = desno.Length;
                int index = 0;
                while (li < ln && di < dn)
                {
                    if (levo[li].weight < desno[di].weight) outKutija[index++] = levo[li++];
                    else outKutija[index++] = desno[di++];
                }
                while (li < ln)
                {
                    outKutija[index++] = levo[li++];
                }
                while (di < dn)
                {
                    outKutija[index++] = desno[di++];
                }
            }
            else outKutija[0] = kutije[startIndex];
            return outKutija;
        }

        static Predmet[] GetPredmeti(int n)
        {
            Predmet[] predmeti = new Predmet[n];
            double[] weights = GetValues(n);
            double[] values = GetValues(n);            
            for(int i = 0; i < n; ++i) predmeti[i] = new Predmet(values[i], weights[i]);            
            return SortPredmeti(predmeti,0,n - 1);
        }

        static Kutija[] GetKutijas(int n)
        {
            Kutija[] kutije = new Kutija[n];
            double[] weights = GetValues(n);
            for (int i = 0; i < n; ++i) kutije[i] = new Kutija(weights[i]);            
            return SortKutija(kutije,0,n - 1);
        }
        static double[] GetValues(int n)
        {
            string[] input = Console.ReadLine().Split(' ');
            double[] array = new double[n];
            for(int i = 0; i < n; ++i)  array[i] = Convert.ToDouble(input[i]);
            return array;
        }
    }
    class MaxPredmet
    {
        Predmet predmet;
        MaxPredmet najblizi;
        public MaxPredmet(Predmet predmet)
        {
            this.predmet = predmet;                    
        }
        public MaxPredmet(Predmet predmet, MaxPredmet najblizi)
        {
            this.predmet = predmet;
            this.najblizi = najblizi;
        }
        public Predmet GetPredmet()
        {
            return predmet;
        }
        public MaxPredmet GetNajblizi()
        {
            return najblizi;
        }
        public void SetNajblizi(Predmet najbliziPredmet)
        {
            najblizi = new MaxPredmet(najbliziPredmet, najblizi);
        }
    }
    class Predmet
    {
        public double weight;
        public double value;
        public Predmet(double value, double weight)
        {
            this.value = value;
            this.weight = weight;
        }
    }
    class Kutija
    {
        public double weight;
        public Kutija(double weight)
        {
            this.weight = weight;
        }       
    }
}