#include <iostream>
#include <vector>
#include <algorithm>
//#include "Generator.h"
#include <ctime>
#include <cstdlib>

using namespace std;

typedef unsigned long long ull;

struct predmet{
	int v;
	int t;
};
struct kutija{
	kutija(): prazna{true}{}
	int c;
	bool prazna;
};

bool operator <(const predmet& a, const predmet& b){
	return a.v > b.v;
}

bool operator <(const kutija& a, const kutija& b){
	return a.c < b.c;
}

int forceSearch(const vector<kutija>& vec, int value);
int validate(const vector<kutija>& vec, int index);
ull resf(vector<predmet>& p, vector<kutija>& k);
ull mainFunction(vector<predmet>& p, vector<kutija>& k);


int main(int argc, char** argv) {
	predmet ulazp;
	ulazp.v = 0;
	kutija ulazk;
	vector<predmet> p;
	vector<kutija> k;
	int ps, ks;
	cin >> ps >> ks;
	for(int i = 0; i < ps; ++i){
		cin >> ulazp.t;
		p.push_back(ulazp);
	}
	for(int i = 0; i < ps; ++i){
		cin >> p[i].v;
	}
	for(int i = 0; i < ks; ++i){
		cin >> ulazk.c;
		k.push_back(ulazk);
	}
	cout << mainFunction(p, k) << endl;
	return 0;
}

int validate(const vector<kutija>& vec, int index){
	if(vec[index].prazna){
		return index;
	}
	else{
		int s = vec.size();
		for(int i = index+1; i < s; ++i){
			if(vec[i].prazna){
				return i;
			}
		}
	}
	return -1;
}

int forceSearch(const vector<kutija>& vec, int value){
	int max, min, target;
	min = 0;
	max = vec.size() - 1;
	if(vec[min].c == value){
		return min;
	}
	if(vec[max].c == value){
		return max;
	}
	while(max - min > 1){
		target = (min+max)/2;
		if(vec[target].c == value){
			return validate(vec, target);
		}
		if(vec[target].c > value){
			max = target;
		}
		else{
			min = target;
		}
	}
	target = (min+max)/2;
	if(vec[target].c > value){
		while(vec[target].c > value && target >= 0){
			--target;
		}
		++target;
		return validate(vec, target);
	}
	else{
		while(vec[target].c < value){
			++target;
			if(target >= vec.size()){
				return -1;
			}
		}
		return validate(vec, target);
	}
}

ull resf(vector<predmet>& p, vector<kutija>& k){
	int s = p.size();
	int res;
	ull total = 0;
	for(int i = 0; i < s; ++i){
		res = forceSearch(k, p[i].t);
		if(res != -1){
			k[res].prazna = false;
			total += p[i].v;
		}
	}
	return total;
}

ull mainFunction(vector<predmet>& p, vector<kutija>& k){
	sort(p.begin(), p.end());
	sort(k.begin(), k.end());
	return resf(p, k);
}