#include<iostream>
#include<stdio.h>
#include<math.h>

#define DOUBLE_EQUAL_THRESHOLD 0.01

#define MAX_N 10000

using namespace std;

struct Point{
    double x;
    double y;
    Point(){
        x = y = 0;
    }
    Point(double t_x, double t_y){
        x = t_x;
        y = t_y;
    }
};

struct Line{
    double a;
    double b;
    double c;
    Line(){
        a = b = c;
    }
    Line(Point p, Point q){
        a = q.y - p.y;
        b = p.x - q.x;
        c = -(a * (p.x) + b * (p.y));
    }
};

struct Circle{
    Point c;
    double r;
};

struct Elem{
    Line l;
    Elem* ptr;
    Elem(Line t_l, Elem* t_ptr = NULL){
        l = t_l;
        ptr = t_ptr;
    }
};

struct Pointer{
    Elem* cur;
    Elem* prev;
};

inline double getDistFromLine(Point p, Line l){
    return fabs(((l.a * (p.x)) + ((l.b) * (p.y)) + (l.c))/sqrt((l.a*l.a) + (l.b*l.b)));
}

void push(Elem* &p, Line l){
    if(p == NULL){
        p = new Elem(l);
    }
    else{
        p = new Elem(l, p);
    }
}

void pop(Elem* &poc, Pointer &p){
    if(p.cur == poc){
        poc = poc->ptr;
        return;
    }
    if(p.cur->ptr == NULL){
        p.prev = NULL;
        delete p.cur;
        return;
    }
    p.prev->ptr = p.cur->ptr;
    delete p.cur;
}

void getCounters(int N, Elem* &cab, int Q, Circle cr[], int counter[]){
    Pointer p;
    for(int i=0;i<Q;i++){
        p.cur = p.prev = cab;
        counter[i] = i>0 ? counter[i-1] : 0;
        while(p.cur != NULL){
            if(getDistFromLine(cr[i].c, p.cur->l) - cr[i].r < DOUBLE_EQUAL_THRESHOLD){
                counter[i]++;
                pop(cab, p);
            }
            if(p.cur != cab){
                p.prev = p.cur;
            }
            p.cur = p.cur->ptr;
        }
    }
}

void input(int &N, Elem* &cab, int &Q, Circle cr[]){
    scanf("%d", &N);
    Line tmp[MAX_N];
    Point t1;
    Point t2;
    for(int i=N-1;i>=0;i--){
        scanf("%lf %lf", &t1.x, &t1.y);
        scanf("%lf %lf", &t2.x, &t2.y);
        tmp[i] = Line(t1, t2);
    }
    for(int i=0;i<N;i++){
        push(cab, tmp[i]);
    }
    scanf("%d", &Q);
    for(int i=0;i<Q;i++){
        cin >> cr[i].c.x >> cr[i].c.y >> cr[i].r;
    }
}



int main(){
    int N;
    Elem* cab = NULL;
    int Q;
    Circle cr[MAX_N];
    int counter[MAX_N];
    input(N, cab, Q, cr);

    getCounters(N, cab, Q, cr, counter);

    for(int i=0;i<Q;i++){
        cout << counter[i] << endl;
    }

    return 0;
}