#include <bits/stdc++.h>
using namespace std;

typedef unsigned long long ull;

template<typename type>
struct SegmentTree
{
    int n; // size
    type *arr; // array 1-indexed
    type NTR; // neutral element

    type operate(type a, type b) {
        if (a == 0 && b == 0) return 0;
        if (a == 0) return b;
        if (b == 0) return a;

        while (a % 2ull == 0ull) a /= 2ull;
        while (b % 2ull == 0ull) b /= 2ull;
        if (a == b) return a;

        if (a > b) swap(a, b);
        return operate(a, b ^ a);
    }

    int power_up(int a) {
        int ret = 1;
        while (a != 0) a >>= 1, ret <<= 1;
        return ret;
    }

    SegmentTree(int m, type ntr = 0) {
        n = power_up(m);
        NTR = ntr;
        arr = new type[n+n];
        fill(arr, arr+n+n, NTR);
    }

    SegmentTree(int m, vector<type> a, type ntr = 0) {
        n = power_up(m);
        NTR = ntr;
        arr = new type[n+n];
        for (int i = 0; i < n; i++) {
            if (i >= m) arr[i+n] = NTR;
            else arr[i+n] = a[i];
        }
        for (int i = n-1; i > 0; i--) {
            arr[i] = operate(arr[i*2], arr[i*2+1]);
        }
    }

    void update(int pos, type val) {
        pos += n - 1;
        arr[pos] = val;
        pos >>= 1;
        while (pos != 0) {
            arr[pos] = operate(arr[pos*2], arr[pos*2+1]);
            pos >>= 1;
        }
    }

    type query(int node, int l, int r, int i, int j) {
        if (i <= l && r <= j) return arr[node];
        if (j < l || r < i) return NTR;
        int mid = (l+r)>>1;
        type left = query(node*2, l, mid, i, j);
        type right = query(node*2+1, mid+1, r, i, j);
        return operate(left, right);
    }

    type query(int l, int r) {
        return query(1, 1, n, l, r);
    }
};


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr); cout.tie(nullptr);

    int n; cin >> n;
    vector<ull> a(n);
    for (auto &it : a)
        cin >> it;

    SegmentTree<ull> boban(n, a, 0ull);

    int q; cin >> q;
    while (q--) {
        int t; cin >> t;
        if (t == 1) {
            int pos; ull val;
            cin >> pos >> val;
            boban.update(pos, val);
        }
        if (t == 2) {
            int l, r;
            cin >> l >> r;
            cout << boban.query(l, r) << '\n';
        }
    }

    return 0;
}