#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

bool comp(const pair<int, int> &a, const pair<int, int> &b) {
	return a.second > b.second || (a.second == b.second && a.first > b.first);
}

int main() {
	int m, n;
	cin >> m >> n;
	
	vector<pair<int, int> > P(m), P2(m); // <tezina, vrednost>
	vector<int> C(n);
	
	for (int i = 0; i < m; i++) cin >> P[i].first;
	for (int i = 0; i < m; i++) cin >> P[i].second;
	for (int i = 0; i < n; i++) cin >> C[i];

	sort(P.begin(), P.end(), comp);
	sort(C.begin(), C.end());
	
	long long res = 0;
	
	for (int i = 0; i < m; i++) {
		int vrednost = P[i].second;
		int tezina = P[i].first;
		
		vector<int>::iterator it = lower_bound(C.begin(), C.end(), tezina + 1);
		
		if (it != C.end()) {
			res += vrednost;
			C.erase(it);
		}
	}
	
	cout << res << endl;
	
	return 0;	
}