#include <bits/stdc++.h>

using namespace std;

#define int ll
typedef long long ll;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<bool> vb;
typedef vector<char> vc;
typedef vector<string> vs;
typedef vector<pi> vp;
typedef vector<pl> vpl;

int gcd(int a, int b){

	if (!a || !b)
		return a + b;

	if (a > b)
		swap(a, b);

	return gcd(a, b % a);
}

int kv(int a){
	return a * a;
}

bool f(double a, double b){
	return a == b;
}

struct point{
	int x;
	int y;
};

struct line{
	int a;
	int b;
	int c;
	int i;
};

line transfer(point a, point b, int i){
	int A = a.y - b.y;
	int B = b.x - a.x;
	int C = a.x * b.y - b.x * a.y;

	int g = gcd(abs(A), abs(B));
	g = gcd(g, abs(C));

	A /= g;
	B /= g;
	C /= g;

	return {A, B, C, i};
}

struct circle{
	int x;
	int y;
	int r;
	int i;

	bool operator< (const circle& o) const{
		return r < o.r;
	}
};

//Preuzeto sa: https://www.geeksforgeeks.org/check-line-touches-intersects-circle/
bool checkCollision(int a, int b, int c, int x, int y, double radius) 
{ 
	double dist = (abs(a * x + b * y + c)) / sqrt(a * a + b * b); 

	if (radius >= dist) 
		return 1;
	else
		return 0;
} 

double dis(point a, line l){
	double sol = (abs(l.a * a.x + l.b * a.y + l.c)) / sqrt(l.a * l.a + l.b * l.b);
	return sol;
}

signed main()
{
	ios_base::sync_with_stdio(false); 
	cin.tie(nullptr); 
	cout.tie(nullptr); 
	cerr.tie(nullptr);	

	//cout << checkCollision(-4, -9, -11, 0, 5, 1);
	//return 0;

	int n;
	cin >> n;
	vector<line> a;

	bool height = 0;
	for (int e = 0; e < n; ++e){
		point c, b;
		cin >> c.x >> c.y >> b.x >> b.y;

		a.push_back(transfer(c, b, e));
	}
	//return cout << "DJAVO", 0;
	int q;
	cin >> q;

	vector<circle> b(q);
	bool ok = 0;
	for (int i = 0; i < q; ++i){
		cin >> b[i].x >> b[i].y >> b[i].r;

		b[i].i = i;
		if (!i) continue;
		if (b[i - 1].x != b[i].x || b[i - 1].y != b[i].y) ok = 1;
	}


	if (n <= 500 && q <= 500){

		for (auto& k : b){
			int sol = 0;
			for (auto& l : a){
				if (checkCollision(l.a, l.b, l.c, k.x, k.y, k.r))
					++sol;
			}
			cout << sol << '\n';
		}

		return 0;
	}

	sort(b.begin(), b.end());
	vi d(q, 0);
	for (auto& i : a){
		if (!checkCollision(i.a, i.b, i.c, b[q - 1].x, b[q - 1].y, b[q - 1].r))
			continue;

		int l = 0, r = q - 1, sol = INT32_MAX;
		while (l <= r){
			int mid = (l + r) / 2;

			if (checkCollision(i.a, i.b, i.c, b[mid].x, b[mid].y, b[mid].r)){
				sol = min(sol, mid);
				r = mid - 1;
			} else {
				l = mid + 1;
			}
		}

		++d[sol];
	}

	for (int i = 1; i < q; ++i)
		d[i] += d[i - 1];

	vi sol(q);
	for (int i = 0; i < q; ++i){
		sol[b[i].i] = d[i];
	}


	for (int i = 0; i < q; ++i)
		cout << sol[i] << ' ';
	cout << '\n';
}