#include <bits/stdc++.h>
using namespace std;
#define ll long long
#define pb push_back
#define mp make_pair
#define ldb long double
#define mt make_tuple
const int N=100050;
struct pt{ ll x,y;pt(){}pt(ll a, ll b):x(a),y(b){}};
pt operator - (pt a, pt b){ return pt(a.x-b.x,a.y-b.y);}
ll cross(pt a, pt b){ return a.x*b.y-a.y*b.x;}
ll dot(pt a, pt b){ return a.x*b.x+a.y*b.y;}
ll sq(pt a){ return dot(a,a);}
ldb abs(pt a){ return sqrt(sq(a));}
struct line{ pt v;ll c;line(){}line(pt a, pt b):v(a-b),c(cross(v,a)){}};
ll side(line l, pt a){ return l.c-cross(l.v,a);}
pair<ll,ldb> dist(line l, pt a){ return mp(abs(side(l,a)),abs(l.v));}
int x[N],y[N],u[N],v[N],a[N],b[N],r[N],n,q,ans[N];
void input()
{
	scanf("%i",&n);
	for(int i=1;i<=n;i++) scanf("%i %i %i %i",&x[i],&y[i],&u[i],&v[i]);
	scanf("%i",&q);
	for(int i=1;i<=q;i++) scanf("%i %i %i",&a[i],&b[i],&r[i]);
}
void output()
{
	for(int i=1;i<=q;i++) printf("%i\n",ans[i]);
}
pt QS[N];
void Solve(int l, int r, vector<line> ls, int add)
{
    if(l>r) return;
    int mid=l+r>>1;
    vector<line> L,R;
    for(int i=0;i<ls.size();i++)
	{
		pair<ll,ldb> p=dist(ls[i],QS[mid]);
		if(p.first<=::r[mid]*p.second) L.pb(ls[i]);
		else R.pb(ls[i]);
	}
	ls.clear();
	ans[mid]=add+L.size();
	Solve(l,mid-1,L,add);
	Solve(mid+1,r,R,add+L.size());
}
void Solve()
{
	vector<line> ls;
	for(int i=1;i<=n;i++) ls.pb(line(pt(x[i],y[i]),pt(u[i],v[i])));
	for(int i=1;i<=q;i++) QS[i]=pt(a[i],b[i]);
	Solve(1,q,ls,0);
}
void Run()
{
	input();
	Solve();
	output();
}
int bans[N];
void BruteForce()
{
	vector<line> ls;
	for(int i=1;i<=n;i++) ls.pb(line(pt(x[i],y[i]),pt(u[i],v[i])));
	for(int i=1;i<=q;i++)
	{
		pt tmp=pt(a[i],b[i]);
		bans[i]=0;
		for(auto l:ls)
		{
			pair<ll,ldb> p=dist(l,tmp);
			if(p.first<=r[i]*p.second) bans[i]++;
		}
	}
}
const int mx=1e8;
void MakeTestCase()
{
	n=rand()%100000+1;
	q=rand()%100000+1;
	for(int i=1;i<=n;i++)
	{
		x[i]=rand()%(mx*2+1)-mx;
		y[i]=rand()%(mx*2+1)-mx;
		u[i]=rand()%(mx*2+1)-mx;
		v[i]=rand()%(mx*2+1)-mx;
		if(mp(x[i],y[i])==mp(u[i],v[i])) i--;
	}
	for(int i=1;i<=q;i++)
	{
		a[i]=rand()%(mx*2+1)-mx;
		b[i]=rand()%(mx*2+1)-mx;
		r[i]=rand()%mx+1;
		if(i>1)
		{
			r[i]=max((int)ceil(abs(pt(a[i],b[i])-pt(a[i-1],b[i-1])))+r[i-1],r[i]);
		}
	}
}
bool Compare()
{
	for(int i=1;i<=q;i++) if(ans[i]!=bans[i]) return 0;
	return 1;
}
void Print()
{
	printf("%i %i\n",n,q);
	for(int i=1;i<=n;i++) printf("%i %i %i %i\n",x[i],y[i],u[i],v[i]);
	for(int i=1;i<=q;i++) printf("%i %i %i\n",a[i],b[i],r[i]);
	printf("Solve: ");
	for(int i=1;i<=q;i++) printf("%i ",ans[i]);printf("\n");
	printf("Brute: ");
	for(int i=1;i<=q;i++) printf("%i ",bans[i]);printf("\n");
}
double GetTime(){ return (ldb)clock()/CLOCKS_PER_SEC;}
double s_time,e_time,d_time;
void Start(){ s_time=GetTime();}
void Stop(){ e_time=GetTime();d_time=e_time-s_time;}
void Test()
{
	cout<<fixed<<setprecision(4);
	int work=100000;
	double max_time=0;
	bool speed_only=1;
	for(int i=1;i<=work;i++)
	{
		MakeTestCase();
		if(!speed_only) BruteForce();
		Start();
		Solve();
		Stop();
		if(!speed_only && !Compare())
		{
			Print();
			return;
		}
		max_time=max(max_time,d_time);
		cout<<i<<":OK, max time so far="<<max_time<<"\n";
	}
	cout<<":D\n";
}
int main()
{
	bool test=1;
	if(test) Test();
	else Run();
	return 0;
}