// KORISCEN KOD SA LINKA https://www.geeksforgeeks.org/minimum-xor-value-pair/
// jer nisam stigao da napisem svoju trie strukturu
#include <bits/stdc++.h>
#define maxn 100010
#define int long long
using namespace std;

int n, q, a[maxn];
vector<int> tmp;
struct TrieNode { 
    int value; // used in leaf node 
    TrieNode* Child[2]; 
}; 
  
TrieNode* getNode() 
{ 
    TrieNode* newNode = new TrieNode; 
    newNode->value = 0; 
    newNode->Child[0] = newNode->Child[1] = NULL; 
    return newNode; 
} 
void insert(TrieNode* root, int key) 
{ 
    TrieNode* temp = root; 
    for (int i = 62; i >= 0; i--) { 
        bool current_bit = (key & (1LL << i)); 
        if (temp->Child[current_bit] == NULL) 
            temp->Child[current_bit] = getNode(); 
  
        temp = temp->Child[current_bit]; 
    } 
    temp->value = key; 
} 
int minXORUtil(TrieNode* root, int key) 
{ 
    TrieNode* temp = root; 
  
    for (int i = 62; i >= 0; i--) { 
        bool current_bit = (key & (1LL << i)); 
        if (temp->Child[current_bit] != NULL) 
            temp = temp->Child[current_bit]; 
        else if (temp->Child[1 - current_bit] != NULL) 
            temp = temp->Child[1 - current_bit]; 
    } 
    return key ^ temp->value; 
} 
int minXOR() 
{ 
    int min_xor = 5e18;
    TrieNode* root = getNode(); 
    insert(root, 0); 
    for (auto i : tmp) { 
        min_xor = min(min_xor, minXORUtil(root, i)); 
        insert(root, i); 
    } 
    return min_xor; 
} 
int invert(int x){
	int res = 0;
	for(int i = 0; i < 62; ++i){
		res *= 2;
		res += (x&1);
		x >>= 1;
	}
	return res;
}

int sol1(){
	for(int i = 0; i < tmp.size(); ++i){
		tmp[i] = invert(tmp[i]);
	}
	int res = minXOR();
	res = invert(res);
	return res / (res&-res);
}

int sol(){
	bool app[10];
	int num = 0;
	memset(app, 0, sizeof app);
	for(auto i : tmp){
		if(i > 8){
			return sol1();
		}
		if(!app[i]){
			++num;
		}
		app[i] = 1;
	}
	if(app[1] or app[2] or app[4] or app[8]){
		return 1;
	} else if(num == 1){
		if(app[6]){
			return 3;
		} else {
			return tmp[0];
		}
	} else {
		if(app[7]){
			return 1;
		} else {
			return 3;
		}
	}
}

signed main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cin >> n;
	for(int i = 0; i < n; ++i){
		cin >> a[i+1];
	}
	cin >> q;
	for(int i = 0; i < q; ++i){
		int t, l, r;
		cin >> t >> l >> r;
		if(t == 2){
			tmp.clear();
			for(int i = l; i <= r; ++i){
				tmp.push_back(a[i]);
			}
			cout << sol() << '\n';
		} else {
			a[l] = r;
		}
	}
}