#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

#define PB push_back
#define MP make_pair
#define F first
#define S second

int n, q;

struct Point{
    ll x, y;
};

struct Circle{
    ll x, y, rad; // radius
};

void displayPoint(Point point){
    printf("\n%lld %lld", point.x, point.y);
}

void displayBoolArr(bool arr[]){
    for(int i = 0; i < n; i++){
        printf("%s ", arr[i] ? "true" : "false");
    }
}

typedef pair<Point, Point> pp;
typedef vector<pp> vpp;
typedef vector<Circle> vc;
typedef vector<int> vi;

vpp cables;
vc circles;
vi results;

void input(){
    scanf("%d", &n);
    Point cur_A, cur_B;
    for(int i = 0; i < n; i++){
        scanf("%lld %lld %lld %lld", &cur_A.x, &cur_A.y, &cur_B.x, &cur_B.y);
        cables.PB(MP(cur_A, cur_B));
    }
    scanf("%d", &q);
    Circle cur_C;
    for(int i = 0; i < q; i++){
        scanf("%lld %lld %lld", &cur_C.x, &cur_C.y, &cur_C.rad);
        circles.PB(cur_C);
    }
}

void output(){
    for(auto it : results){
        printf("%d\n", it);
    }
}


int getIntersections(Circle circle, bool history[]){
    int out = 0;
    for(int i = 0; i < n; i++){
        if(history[i] == true){
            out++;
            continue;
        }
        Point A, B;
        A = cables[i].F; B = cables[i].S;
        double height = abs((B.y - A.y)*circle.x - (B.x - A.x)*circle.y + B.x*A.y - B.y*A.x);
        height /= sqrt(pow(B.y - A.y, 2) + pow(B.x - A.x, 2));
        if(circle.rad >= height){
            history[i] = true;
            out++;
        }
    }
    return out;
}

void Solve(){
    bool history[n];
    for(int i = 0; i < q; i++){
        int cur_res = getIntersections(circles[i], history);
        results.PB(cur_res);
    }
}

int main()
{
    input();
    Solve();
    output();

    return 0;
}