using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp28
{
    class Program
    {
        struct Predmet
        {
            public uint tezina;
            public uint vrednost;
        }
        struct Kutija
        {
            public uint nosivost;
            public bool prazna;
        }
        static Predmet[] predmets;
        static Kutija[] kutije;
        static void Main(string[] args)
        {
            int m, n;
            string[] read = Console.ReadLine().Split(' ');
            m = int.Parse(read[0]);
            n = int.Parse(read[1]);
            predmets = new Predmet[m];
            kutije = new Kutija[n];

            read= Console.ReadLine().Split(' ');
            string[] read1= Console.ReadLine().Split(' ');
            for (int i = 0; i < m; i++)
            {
                predmets[i].tezina = uint.Parse(read[i]);
                predmets[i].vrednost = uint.Parse(read1[i]);
            }

            read= Console.ReadLine().Split(' ');
            for(int i = 0; i < n; i++)
            {
                kutije[i].nosivost = uint.Parse(read[i]);
                kutije[i].prazna = true;
            }
            quicksortPredmeti(predmets, 0, m - 1);
            quicksortKutije(kutije, 0, n - 1);
            Console.WriteLine(zauzmiKutije(kutije));

        }
        static void swap(int a,int b)
        {
            Predmet z = predmets[a];
            predmets[a] = predmets[b];
            predmets[b] = z;
        }
        static void swapK(int a, int b)
        {
            Kutija z = kutije[a];
            kutije[a] = kutije[b];
            kutije[b] = z;
        }
        static void quicksortPredmeti(Predmet[] niz,int first,int last)
        {
            int l = first + 1;
            int h = last;
            uint current = niz[first].vrednost;
            while (l <= h)
            {
                while (niz[l].vrednost > current && l < last) l++;
                while (niz[h].vrednost < current && h > first) h--;
                if (l < h)
                    swap(l++, h--);
                else l++;
            }
            swap(first, h);
            if (first < h - 1) quicksortPredmeti(niz, first, h - 1);
            if (h + 1 < last) quicksortPredmeti(niz, h + 1, last);
        }

        static void quicksortKutije(Kutija[] niz, int first, int last)
        {
            int l = first + 1;
            int h = last;
            uint current = niz[first].nosivost;
            while (l <= h)
            {
                while (niz[l].nosivost > current && l < last) l++;
                while (niz[h].nosivost < current && h > first) h--;
                if (l < h)
                    swapK(l++, h--);
                else l++;
            }
            swapK(first, h);
            if (first < h - 1) quicksortKutije(niz, first, h - 1);
            if (h + 1 < last) quicksortKutije(niz, h + 1, last);
        }
        static long zauzmiKutije(Kutija[] kutije)
        {
            long res = 0;
           for(int i = 0; i < predmets.Length; i++)
            {
                uint tezina = predmets[i].tezina;
                uint vrednost = predmets[i].vrednost;
                int first = 0;
                int last = kutije.Length - 1;
                bool cont = true;
                while (first<=last && cont) {
                    int sred = (first + last) / 2;
                    if (tezina > kutije[sred].nosivost) last = sred-1;
                    else if (tezina == kutije[sred].nosivost && kutije[sred].prazna)
                    {
                        kutije[sred].prazna = false;
                        cont = false;
                        res += vrednost;
                    }
                    else first = sred+1;
                }
                while (last >= 0 && cont)
                {
                    if (kutije[last].prazna)
                    {
                        kutije[last].prazna = false;
                        res += vrednost;
                        cont = false;
                    }
                    last--;
                }
                
            }
            return res;
        }

        
    }
}