#include <bits/stdc++.h>
using namespace std;

#define long int64_t
#define endl '\n'

#ifdef OFFLINE
	#define logan(...) logg(#__VA_ARGS__, __VA_ARGS__)
	template<class Arg>
	void logg(const char* name, Arg&& arg){ cerr << name << ": " << arg << '\n'; }
	template<class Arg, class ... Args>
	void logg(const char* name, Arg&& arg, Args&& ... args){
		const char* next = strchr(name+1, ',');
		cerr.write(name, next-name) << ": " << arg << ",";
		logg(next+1, args...);
	}
	#define timeme 1.0*clock()/CLOCKS_PER_SEC
#else
	#define logan(...) {}
	#define timeme {}
#endif

struct pr{
	double a, b;

	double operator^ (const pr& o) const{ return (a-o.a)*(a-o.a) + (b-o.b)*(b-o.b); }
	double operator* (const pr& o) const{ return (a*o.a)+(b*o.b); }
	pr operator- (const pr& o) const{ return pr{a-o.a, b-o.b}; }
};

struct tpl{
	double a, b, c;
};

pr s[100'001];
pr e[100'001];
int t[100'001];
tpl qry[100'001];
double d[100'001];


double ptl(pr a, pr b, pr c){
	double l = b^c;
	double t = ((a-b)*(c-b))/l;
	return sqrt((a^pr{ t*(c.a-b.a)+b.a, t*(c.b-b.b)+b.b}));
}

/* HIW */
void sub1(int n, int q){
	int res = 0;
	for(int i = 0; i < q; ++i){
		for(int j = 0; j < n; ++j){
			if(t[j]) continue;
			if(ptl({qry[i].a, qry[i].b}, s[j], e[j]) <= qry[i].c){
				++res;
				t[j] = 1;
			}
		}
		cout << res << endl;
	}
	exit(0);
}

/* Concentric */
void sub2(int n, int q){
	for(int i = 0; i < n; ++i){
		d[i] = ptl({qry[0].a, qry[0].b}, s[i], e[i]);
	}

	sort(d, d+n);
	for(int i = 0; i < q; ++i){
		int res = lower_bound(d, d+n, qry[i].c)-d;
		if(d[res] <= qry[i].c) ++res;
		cout << res << endl;
	}
	exit(0);
}

/* Horizontal */
void sub3(int n, int q){
	for(int i = 0; i < q; ++i){
		int res = 0;
		for(int j = 0; j < n; ++j)
			if(abs(qry[i].b-s[j].b) <= qry[i].c) ++res;
		cout << res << endl;
	}
	exit(0);
}

int main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);
	cerr.tie(nullptr);

	int n; cin >> n;

	int horizontal = 1;
	for(int i = 0; i < n; ++i){
		double x, y, u, v; cin >> x >> y >> u >> v;
		horizontal = horizontal && y == v;
		s[i] = {x, y};
		e[i] = {u, v};
	}

	int q; cin >> q;

	int concentric = 1;
	for(int i = 0; i < q; ++i){
		double a, b, r;
		cin >> a >> b >> r;
		qry[i] = {a, b, r};
		if(i) concentric = concentric && qry[i].a == qry[i-1].a && qry[i].b == qry[i-1].b;
	}

	if(horizontal) sub3(n, q);
	if(concentric) sub2(n, q);
	sub1(n, q);

}