#include <algorithm>
#include <iostream>
#include <vector>

struct Predmet
{
    long long w;
    long long v;
};

bool operator==(const Predmet &a, const Predmet &b)
{
    return a.w == b.w && a.v == b.v;
}

struct Kutija
{
    long long c;
    Predmet *p;
};

int main()
{
    int m, n;
    std::cin >> m >> n;

    std::vector<Predmet> pv(m);
    std::vector<Kutija> kv(n);

    for (int i = 0; i < m; i++)
    {
        Predmet p;
        std::cin >> p.w;
        pv[i] = p;
    }

    for (int i = 0; i < m; i++)
    {
        std::cin >> pv[i].v;
    }

    for (int i = 0; i < n; i++)
    {
        Kutija k;
        std::cin >> k.c;
        kv[i] = k;
    }

    struct {
        bool operator()(Predmet a, Predmet b) const
        {   
            return a.v < b.v;
        }   
    } valueCompare;

    struct {
        bool operator()(Kutija a, Kutija b) const
        {   
            return a.c < b.c;
        }   
    } boxCompare;

    std::sort(kv.begin(), kv.end(), boxCompare);

    long long res = 0;

    for (Kutija k : kv)
    {
        std::vector<Predmet> fit;

        std::copy_if(pv.begin(), pv.end(), std::back_inserter(fit), [&](Predmet p){ return p.w <= k.c; } );

        Predmet tmp = *std::max_element(fit.begin(), fit.end(), valueCompare);
        k.p = &tmp;
        pv.erase(std::remove(pv.begin(), pv.end(), tmp), pv.end());

        res += k.p->v;
    }

    std::cout << res << std::endl;
    
    return 0;
}