#include <cmath>
#include <iostream>
#include <vector>

struct Point
{
    long long x;
    long long y;
};

struct Line 
{
    Point one;
    Point two;
};

struct Circle
{
    Point c;
    long long r;
};

int main()
{
    int n;
    std::cin >> n;

    std::vector<Line> lv(n);

    for (int i = 0; i < n; i++)
    {
        Line l;
        std::cin >> l.one.x >> l.one.y >> l.two.x >> l.two.y;
        lv[i] = l;
    }

    int q;
    std::cin >> q;

    std::vector<Circle> cv(q);

    for (int i = 0; i < q; i++)
    {
        Circle c;
        std::cin >> c.c.x >> c.c.y >> c.r;
        cv[i] = c;
    }

    for (Circle c : cv)
    {
        int count = 0;
        for (Line l : lv)
        {
            double distToCenter = std::abs((l.two.x - l.one.x) * (l.one.y - c.c.y) - (l.one.x - c.c.x) * (l.two.y - l.one.y)) / std::sqrt(std::pow(l.two.x - l.one.x, 2) + std::pow(l.two.y - l.one.y, 2));

            if (distToCenter <= c.r)
            {
                count++;
            }
        }
        std::cout << count << std::endl;
    }
}