#include <algorithm>
#include <iostream>
#include <vector>

void replace(std::vector<unsigned long long> *nb, int pos, unsigned long long rep)
{
    auto it = nb->erase(nb->begin() + (pos - 1));
    nb->insert(it, rep);
}

std::vector<unsigned long long> doXor(std::vector<unsigned long long> v)
{
    for (int i = 0; i < 100; i++)
    {
        v.emplace_back((unsigned long long)(v[i] ^ v[i + 1]));
    }

    return v;
}

std::vector<unsigned long long> doDouble(std::vector<unsigned long long> v)
{
    for (int i = 0; i < 100; i++)
    {
        v.emplace_back(v[i] * 2);
    }

    return v;
}

void doReduce(std::vector<unsigned long long> *v)
{
    for (int i = 0; i < v->size(); i++)
    {
        while (v->at(i) % 2 == 0)
        {
            unsigned long long val = v->at(i) / 2;
            auto it = v->erase(v->begin() + i);
            v->insert(it, val);
        }
    }
}

void game(std::vector<unsigned long long> *nb, int b, int e)
{
    std::vector<unsigned long long> v;

    std::copy(nb->begin() + std::max(0, b - 1), nb->begin() + e, std::back_inserter(v));

    doReduce(&v);

    std::sort(v.begin(), v.end());

    unsigned long long min = v[0];

    if (min == 1)
    {
        std::cout << 1 << std::endl;
        return;
    }

    std::vector<unsigned long long> x, d;
    x = doXor(v);
    doReduce(&x);
    d = doDouble(v);
    d = doXor(d);
    doReduce(&d);

    // :((

    min = std::min(min, std::min(*std::min_element(x.begin(), x.end()), *std::min_element(d.begin(), d.end())));

    std::cout << min << std::endl;
}

int main()
{
    int n;
    std::cin >> n;

    std::vector<unsigned long long> nb(n);

    for (int i = 0; i < n; i++)
    {
        std::cin >> nb[i];
    }

    int q;
    std::cin >> q;

    for (int i = 0; i < q; i++)
    {
        int op, one;
        unsigned long long two;

        std::cin >> op >> one >> two;

        switch (op)
        {
            case 1:
                replace(&nb, one, two);
                break;
            case 2:
                game(&nb, one, (int)two);
                break;
        }
    }

    return 0;
}