#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
const ll MOD = 1e9+7;
const int N = 1e5+5;
const double EPS = 1e-12;

struct Line{
    ll a,b,c;
    Line(ll _a=0LL,ll _b=0LL,ll _c=0LL){
        a=_a;
        b=_b;
        c=_c;
    }
};

struct Circle{
    ll x,y,r;
    Circle(ll _x=0LL,ll _y=0LL,ll _r=0LL){
        x=_x;
        y=_y;
        r=_r;
    }
};

int n,q,ans[N];
Line p[N];
Circle c[N];


bool ok(int ind,Line t){
    ll x=c[ind].x;
    ll y=c[ind].y;
    ll r=c[ind].r;

    double up=(double)abs((double)t.a*(double)x+(double)t.b*(double)y+(double)t.c);
    double down=sqrt((double)t.a*t.a+(double)t.b*t.b)*(double)r;

    if(fabs(up-down)<EPS)return true;
    return up<down;
}

int main()
{
    ios_base::sync_with_stdio(false);cin.tie(0);cout.tie(0);
    cin>>n;

    for(int i=1;i<=n;i++){
        ll x1,x2,y1,y2;
        cin>>x1>>y1>>x2>>y2;

        p[i]=Line(y1-y2,x2-x1,x1*y2-x2*y1);
    }

    cin>>q;
    for(int i=1;i<=q;i++){
        cin>>c[i].x>>c[i].y>>c[i].r;
    }

    for(int i=1;i<=n;i++){
        int lo=1;
        int hi=q;
        int sol=-1;

        while(lo<=hi){
            int mid=(lo+hi)>>1;

            if(ok(mid,p[i])){
                sol=mid;
                hi=mid-1;
            }else{
                lo=mid+1;
            }
        }

        if(sol!=-1){
            ans[sol]++;
        }
    }

    for(int i=1;i<=q;i++){
        ans[i]+=ans[i-1];
    }
    for(int i=1;i<=q;i++)cout<<ans[i]<<"\n";
    return 0;
}