#include <bits/stdc++.h>

using namespace std;

#define MAXN 300005

int n, m;

struct item {
    int weight, value;
};
bool operator<(item a, item b) {return a.value < b.value;};

item items[MAXN];
int bins[MAXN];

void print() {
    for (int i = 0; i < n; i++) {
        cout << items[i].weight << " " << items[i].value << " | ";
    }
    cout << endl;
    for (int i = 0; i < m; i++) {
        cout << bins[i] << " ";
    }
    cout << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m;
    for (int i = 0; i < n; i++) {
        cin >> items[i].weight;
    }
    for (int i = 0; i < n; i++) {
        cin >> items[i].value;
    }
    for (int i = 0; i < m; i++) {
        cin >> bins[i];
    }

    sort(items, items+n);
    sort(items, items+n, [](item a, item b) {return a.weight < b.weight;});
    sort(bins, bins+m);

    priority_queue<item> pq;
    long long total = 0;

    int j = 0;
    for (int i = 0; i < n; i++) {
        if (items[i].weight >= bins[j]) {
            while (!pq.empty() && pq.top().weight >= bins[j]) pq.pop();
            if (!pq.empty()) {
                total += pq.top().value; pq.pop();
            }
            j++;
            if (j == m) break;
        }
        pq.push(items[i]);
    }

    while (j < m) {
        if (!pq.empty()) {
            while (!pq.empty() && pq.top().weight >= bins[j]) pq.pop();
            if (pq.empty()) break;
            total += pq.top().value; pq.pop();
            j++;
        } else {
            break;
        }
    }

    cout << total;

    return 0;
}