#include <bits/stdc++.h>
#define debug(x) cout << #x << " is " << x << '\n';
#define stigao() cout << "Stigao" << '\n';
#define file() freopen("output.txt", "w", stdout);
#define x first
#define y second

using namespace std;

/*
4
4 -3 -5 1
6 -2 -4 10
6 11 6 8
6 8 6 11
3
0 5 1
1 4 3
3 5 6

3
2 -2 0 -2
-3 -4 3 -4
1 -4 0 -6
3
0 -4 1
0 -4 2
2 -7 7
*/

typedef pair<double, double> point;

const int MAXN = 1e5 + 5;
const double EPS = 1e-12;
int cnt[MAXN], dp[MAXN];

point A[MAXN], B[MAXN], center[MAXN];
double radius[MAXN];

bool intersects(int i, int k){
    double a = A[i].y - B[i].y;
    double b = B[i].x - A[i].x;
    double c = A[i].x * B[i].y - B[i].x * A[i].y;

    double dist = (abs(a * center[k].x + b * center[k].y + c)) / sqrt(a * a + b * b);

    return radius[k] - dist >= radius[k] * EPS;
}

int main() {
    ios::sync_with_stdio(0), cin.tie(0), cout.tie(0);
    int N, Q;
    cin >> N;
    for(int i = 1; i <= N; i++){
        cin >> A[i].x >> A[i].y >> B[i].x >> B[i].y;
    }
    cin >> Q;
    for(int i = 1; i <= Q; i++){
        cin >> center[i].x >> center[i].y >> radius[i];
    }
    int l, r, mid;
    bool doesIntersect = false;
    for(int i = 1; i <= N; i++){
        l = 0, r = Q + 1;
        doesIntersect = false;
        while(r - l > 1){
            mid = (l + r) / 2;
            if(intersects(i, mid)){
                doesIntersect = true;
                r = mid;
            } else {
                l = mid;
            }
        }
        if(doesIntersect){
            cnt[r]++;
        }
    }
    for(int i = 1; i <= Q; i++){
        dp[i] = dp[i - 1] + cnt[i];
    }
    for(int i = 1; i <= Q; i++){
        cout << dp[i] << "\n";
    }
    return 0;
}