#include <iostream>
#include <vector>
#include <cmath>

struct Prava
{
	double A, B, C, x, y;
	bool bx = false, by = false;
};

bool proveri(Prava &p, int &x, int &y, int &r)
{
	double d;
	if (p.bx) d = abs(p.x - (double)x);
	else if (p.by) d = abs(p.y - (double)y);
	else d = abs(p.A*x + p.B*y + p.C) / sqrt(p.A*p.A + p.B*p.B);
	if (d > r) return false;
	else return true;
}

int main()
{
	std::ios::sync_with_stdio(false);
	int N;
	std::cin >> N;
	std::vector<Prava> prave(N);
	int x1, x2, y1, y2;
	double k, n;
	for (int i = 0; i < N; i++)
	{
		std::cin >> x1 >> y1 >> x2 >> y2;
		if (x1 == x2)
		{
			prave[i].bx = true;
			prave[i].x = x1;
		}
		else if (y1 == y2)
		{
			prave[i].by = true;
			prave[i].y = y1;
		}
		else
		{
			k = (double)(y2 - y1) / (x2 - x1);
			n = (double)y1 - k*x1;
			prave[i].A = k;
			prave[i].B = (double)-1;
			prave[i].C = n;
		}
	}
	int Q;
	std::cin >> Q;
	int a, b, r, res;
	std::vector<bool> bprava(N, false);
	for (int i = 0; i < Q; i++)
	{
		std::cin >> a >> b >> r;
		res = 0;
		for (int j = 0; j < N; j++)
		{
			if (bprava[j]) res++;
			else if (proveri(prave[j], a, b, r))
			{
				bprava[j] = true;
				res++;
			}
		}
		std::cout << res << "\n";
	}
	return 0;
}