using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Treci_Zadatak
{
    class Vodopad
    {
        int h, n;
        int[,] vodopadProstor;
        int[] Voda;

        public Vodopad()
        {
            string[] temp = Console.ReadLine().Split(' ');

            h = Convert.ToInt32(temp[0]);
            n = Convert.ToInt32(temp[1]);

            vodopadProstor = new Int32[h, n];
            Voda = new int[n];

            for (int i = 0; i < h; i++)
            {
                temp = Console.ReadLine().Split(' ');
                for (int j = 0; j < n; j++)
                {
                    vodopadProstor[i, j] = Convert.ToInt32(temp[j]);
                }
            }

            for (int i = 0; i < n; i++) Voda[i] = 1;
        }

        public void Nadji()
        {
            for (int i = 0; i < h; i++)
            {
                Pad(i);
            }
        }

        private void Pad(int k)
        {
            for (int i = 0; i < n; i++)
            {
                if (vodopadProstor[k, i] == 0 && Voda[i] != 0)
                {
                    Levo(Voda[i] / 2 + ((Voda[i] % 2 == 1 && k % 2 == 0) ? 1 : 0), k, i);
                    Desno(Voda[i] / 2 + ((Voda[i] % 2 == 1 && k % 2 == 1) ? 1 : 0), k, i);
                    Voda[i] = 0;
                }
            }
        }

        private void Levo(int vrednost, int a, int b)
        {
            int temp = 0;

            if (vrednost == 0) return;

            while (vodopadProstor[a, b - temp] != 1)
            {
                if (b == 0) { Desno(vrednost, a, b - temp); return; }
                temp++;
            }

            Voda[b - temp] = Voda[b - temp] + vrednost;
            return;
        }

        private void Desno(int vrednost, int a, int b)
        {
            int temp = 0;
            if (vrednost == 0) return;

            while (vodopadProstor[a, b + temp] != 1)
            {
                if (b == n - 1) { Levo(vrednost, a, b + temp); return; }
                temp++;
            }

            Voda[b + temp] = Voda[b + temp] + vrednost;
            return;
        }

        public void Print()
        {
            for (int i = 0; i < n; i++)
            {
                Console.Write(Voda[i] + " ");
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            Vodopad gostiljskiVodopad = new Vodopad();
            gostiljskiVodopad.Nadji();
            gostiljskiVodopad.Print();
        }
    }
}