#include <bits/stdc++.h>

using namespace std;

#define MAX_SIRINA 100000

int main(int argc, char** argv)
{
	// Visina i sirina vodopada se ucitavaju na pocetku
	
	int visina, sirina;

	cin >> visina;
	cin >> sirina;

	// Vektori za protok pre i posle stena, i stene,
	// da bi indeksi isti od jedan a ne od nule
	
	int protok_pre[MAX_SIRINA];
	int protok_posle[MAX_SIRINA];

	int stena[MAX_SIRINA];
	int postoji_stena = 0;
	int nema_stene    = 1;

	int parni = 0;
	
	// Popunjavamo protok na vrhu vodopada
		
	for ( int kolona = 1 ; kolona <= sirina ; kolona++ )
		protok_pre[kolona] = 1;
	
	// Za svaki red po jednom obradjujemo spoljasnju petlju
	
	for ( int red = 1 ; red <= visina ; red++, parni = !parni )
	{
		// Ucitavamo informaciju o stenam u tekucem redu
		
		for ( int kolona = 1 ; kolona <= sirina ; kolona++ )
			cin >> stena[kolona];

		// Anuliramo vrednost protokola posle stena, zbog sabiranja
		
		for ( int kolona = 1 ; kolona <= sirina ; kolona++ )
			protok_posle[kolona] = 0;
		
		//================================================================
		// Sledi modifikacija protoka u odnosu na stene
		//================================================================

		// prvo prebacimo one protoke koji nemaju stenu, i anuliramo ih pre stene

		for ( int kolona = 1 ; kolona <= sirina ; kolona++ )
			if ( stena[kolona] == nema_stene )
				protok_posle[kolona] = protok_pre[kolona];

		// Trazimo jedan po jedan blok stena, i onda obradjujemo
		// protok iznad tog bloka
		
		int stena_pocetak;
		int stena_kraj = -1;
		
		while ( stena_kraj <= sirina )
		{
			// trazimo pocetak bloka sa stenama, pocev od prethodnog bloka stena
			
			stena_pocetak = 0;
			
			for ( int kolona = stena_kraj + 2 ; kolona <= sirina ; kolona++ )
				if ( stena[kolona] == postoji_stena )
				{
					stena_pocetak = kolona;
					break;
				}
			
			// Ako nismo nasli stenu, onda je izlazak iz petlje
			
			if ( stena_pocetak == 0 )
				break;

			// Trazimo kraj bloka sa stenama
			
			stena_kraj = 0;
			
			for ( int kolona = stena_pocetak + 1 ; kolona <= sirina ; kolona++ )
				if ( stena[kolona] == postoji_stena )
					stena_kraj = kolona;
				else
					break;
			
			// Ako nismo nasli kraj, znaci da je blok sirine jedan
			
			if ( stena_kraj == 0 )
			{
				stena_kraj = stena_pocetak;
			}
			
			// Obrada protoka izmedju stena_pocetak i stena_kraj
			
			// Nadjemo zbirni protok iznad bloka stena
			
			int zbirni_protok = 0;
			
			for ( int kolona = stena_pocetak ; kolona <= stena_kraj ; kolona++ )
				zbirni_protok += protok_pre[ kolona ];
			
			// Ako su stena na pocetku ili na kraju, onda je prosto
			
			if ( stena_pocetak == 1 )
				protok_posle[ stena_kraj + 1 ] += zbirni_protok;
			else if ( stena_kraj == sirina )
				protok_posle[ stena_pocetak - 1 ] += zbirni_protok;
			else
			{
				// Moramo da podelimo protok na dva dela
				
				int protok_levo, protok_desno;
				
				protok_levo = zbirni_protok / 2;
				protok_desno = protok_levo;
				
				if ( zbirni_protok > protok_levo + protok_desno )
				{
					// Imamo jedinicu viska
					
					if ( parni )
						protok_desno++;
					else
						protok_levo++;
				}
				
				protok_posle[ stena_pocetak - 1 ] += protok_levo;
				protok_posle[ stena_kraj + 1 ]    += protok_desno;
			}
		}
		
		//================================================================
		// Kraj glavne obrade
		//================================================================

		// Prebacivanje protoka posle stena u protok pre stena, za naredni ciklus
		
		for ( int kolona = 1 ; kolona <= sirina ; kolona++ )
			protok_pre[kolona] = protok_posle[kolona];
	}
	
	// Stampa rezultata

	for ( int kolona = 1 ; kolona <= sirina ; kolona++ )
		printf ( "%d ", protok_posle[kolona] );
	
	printf( "\n" );
		
	return 0;
}