#include <cstdio>
#include <array>

using u32 = unsigned int;

int main()
{
	std::array<bool, 1'000'000> mapa;
	std::array<u32, 500'000> voda;

	u32 n, h;

	std::scanf("%u %u", &h, &n);

	for (u32 j = 0; j < h; ++j)
		for (u32 i = 0; i < n; ++i)
		{
			int temp;
			std::scanf("%d", &temp);
			mapa[j * n + i] = temp;
		}
	
	for (u32 i = 0; i < n; ++i)
		voda[i] = 1;
	
	u32 row = 0;

	while (row < h)
	{
		int wall_start = -1;
		int wall_end = -1;
		for (u32 i = 0; i < n; ++i)
		{
			if (!(mapa[row * n + i]))
			{
				if (i == 0)
				{
					voda[i + 1] += voda[i];
					voda[i] = 0;
					continue;
				}
				if (i == n - 1)
				{
					voda[i - 1] += voda[i];
					voda[i] = 0;
					continue;
				}
				if (voda[i] & 1)
				{
					u32 half = voda[i] / 2;
					if ((row + 1) & 1)
						voda[i - 1] += 1;
					else
						voda[i + 1] += 1;
					voda[i + 1] += half;
					voda[i - 1] += half;
					voda[i] = 0;
					continue;
				}
				u32 half = voda[i] / 2;
				voda[i + 1] += half;
				voda[i - 1] += half;
				voda[i] = 0;		
			}				
		}
		for (u32 i = 0; i < n; ++i)
			std::printf("%u ", voda[i]);
		std::puts("");	
		++row;
	}

	for (u32 i = 0; i < n; ++i)
		std::printf("%u ", voda[i]);
	std::puts("");
}