#include <cstdio>
#include <array>
#include <numeric>

using u32 = unsigned int;

int main()
{
	std::array<bool, 1'000'000> mapa;
	std::array<u32, 500'000> voda;

	u32 n, h;

	std::scanf("%u %u", &h, &n);

	for (u32 j = 0; j < h; ++j)
		for (u32 i = 0; i < n; ++i)
		{
			int temp;
			std::scanf("%d", &temp);
			mapa[j * n + i] = temp;
		}
	
	for (u32 i = 0; i < n; ++i)
		voda[i] = 1;
	
	u32 row = 0;
	int wall_start = -1;
	int wall_end = -1;
		
	while (row < h)
	{
		for (u32 i = 0; i < n; ++i)
		{
			bool uso = false;
			if (!(mapa[row * n + i]))
			{
				if (wall_start == -1)
				{
					wall_start = i;
					wall_end = i;
				}
				else
					wall_end += 1;
				uso = true;
			}
			if (wall_start == -1)
				continue;			
		
			if (wall_start == n - 1)
			{
				voda[wall_start - 1] += voda[wall_start];
				voda[wall_start] = 0;
				wall_start = -1;
				continue;
			}

			if (wall_end == n - 1)
			{
				u32 am = 0;
				for (u32 j = wall_start; j < n; ++j)
					am += voda[j];

				voda[wall_start - 1] += am;
				for (u32 j = wall_start; j < n; ++j)
					voda[j] = 0;
				wall_start = -1;
				continue;
			}

			if (wall_start == 0)
			{
				u32 am = 0;
				for (u32 j = wall_start; j < wall_end + 1; ++j)
					am += voda[j];
				voda[wall_end + 1] += am;
				for (u32 j = wall_start; j < wall_end + 1; ++j)
					voda[j] = 0;
				wall_start = -1;
				continue;
			}
			
			if (!uso)
			{
				u32 am = 0;
				for (u32 j = wall_start; j < wall_end + 1; ++j)
					am += voda[j];

				u32 half = am / 2;
				voda[wall_start - 1] += half;
				voda[wall_end + 1] += half;
				if (am & 1)
					voda[((row + 1) & 1) ? wall_start - 1 : wall_end + 1] += 1;
				for (u32 j = wall_start; j < wall_end + 1; ++j)
					voda[j] = 0;
				wall_start = -1;
			}
		}	
		++row;
	}

	for (u32 i = 0; i < n; ++i)
		std::printf("%u ", voda[i]);
}