using System;

namespace test
{
    class Program
    {
        static void Main(string[] args)
        {
            int scoreSum, scoreSet;
            string[] input = Console.ReadLine().Split(' ');
            scoreSum = int.Parse(input[0]);
            scoreSet = int.Parse(input[1]);

            int sets = Math.Min(scoreSum / scoreSet, 5);
            if (sets < 3)
            {
                Console.WriteLine(-1);
                return;
            }

            // initial fill
            int[,] setScores = new int[sets, 2];
            int remainingScore = scoreSum;
            for (int i = 0; i < sets; i++)
            {
                setScores[i, 0] = i % 2 == 0 ? scoreSet : 0;
                setScores[i, 1] = i % 2 == 1 ? scoreSet : 0;
                remainingScore -= scoreSet;
            }

            // fill losing team until possible
            for (int i = 0; i < sets && remainingScore > 0; i++)
            {
                int adding = Math.Min(remainingScore, scoreSet - 2);
                setScores[i, i % 2 == 0 ? 1 : 0] += adding;
                remainingScore -= adding;
            }

            // overfill last set
            // must have even remaining score
            if (remainingScore % 2 == 1)
            {
                remainingScore++;
                setScores[0, 1]--;
            }
            setScores[sets - 1, 0] += remainingScore / 2;
            setScores[sets - 1, 1] += remainingScore / 2;

            for (int i = 0; i < sets; i++)
                Console.WriteLine("{0:F0} {1:F0}", setScores[i, 0], setScores[i, 1]);
        }
    }
}