using System;

namespace test
{
    class Program
    {
        static int overwrite(int[,] flow, int j, int s, int e, int n)
        {
            int sum = 0;
            for (int i = s; i <= e; i++)
            {
                sum += flow[j, i];
                flow[j, i] = n;
            }
            return sum;
        }

        static void Main(string[] args)
        {
            int w, h;
            string[] input = Console.ReadLine().Split(' ');
            w = int.Parse(input[1]);
            h = int.Parse(input[0]);

            int[,] structure = new int[h, w];
            for (int j = 0; j < h; j++)
            {
                input = Console.ReadLine().Split(' ');
                for (int i = 0; i < w; i++)
                    structure[j, i] = int.Parse(input[i]);
            }

            int[,] flow = new int[h + 1, w];

            // first row
            for (int i = 0; i < w; i++)
                flow[0, i] = 1;

            // further rows
            for (int j = 1; j <= h; j++)
            {
                // copy last row
                for (int i = 0; i < w; i++)
                    flow[j, i] = flow[j - 1, i];

                // search for blocks
                int bs = -1, be = -1;
                for (int i = 0; i < w; i++)
                {
                    bool blocked = structure[j - 1, i] == 0;
                    if (bs == -1 && blocked)
                        bs = be = i;
                    else if (bs != -1 && blocked)
                        be = i;
                    else if (bs != -1 && !blocked)
                        cork(flow, j, ref bs, ref be, w);
                }
                if (bs != -1)
                    // rightmost block
                    cork(flow, j, ref bs, ref be, w);
            }

            print(flow, h, w);
        }

        private static void cork(int[,] flow, int j, ref int bs, ref int be, int w)
        {
            int size = overwrite(flow, j, bs, be, 0);
            if (bs == 0)
                // left edge
                flow[j, be + 1] += size;
            else if (be == w - 1)
                // right edge
                flow[j, bs - 1] += size;
            else
            {
                // split
                int smallerSize = size / 2;
                int largerSize = size - smallerSize;
                flow[j, bs - 1] += j % 2 == 1 ? largerSize : smallerSize;
                flow[j, be + 1] += j % 2 == 0 ? largerSize : smallerSize;
            }
            // reset block
            bs = be = -1;
        }

        private static void print(int[,] flow, int j, int w)
        {
            for (int i = 0; i < w; i++)
                Console.Write("{0:F0} ", flow[j, i]);
            Console.WriteLine();
        }
    }
}