#include <iostream>
#include <string>
#include <vector>
using namespace std;

vector<vector<int>> vodopadcina;

void GurniRedNapred(int n) 
{
	vector <int> red = vector <int>();
	for (int i = 0; i < n; i++)
	{
		red.push_back(1);
	}
	vodopadcina.push_back(red);
}

void UcitajVodopad(int n, int h) 
{
	GurniRedNapred(n);

	int polje, niz_stena;
	for (int i = 0; i < h; i++)
	{
		vector <int> red = vector <int>();

		niz_stena = 0;
		for (int j = 0; j < n; j++)
		{
			cin >> polje;

			if (polje == 0) 
			{
				niz_stena++;
			}
			else
			{
				if (niz_stena > 0)
				{
					for (int i = 0; i < niz_stena; i++)
					{
						red.push_back(-niz_stena);
					}
					niz_stena = 0;
				}
				red.push_back(0);
			}
		}

		if (niz_stena > 0)
		{
			for (int i = 0; i < niz_stena; i++)
			{
				red.push_back(-niz_stena);
			}
		}

		vodopadcina.push_back(red);
	}
}

int OdrediBrojVode(int pocetak, int kraj, int red) 
{
	int broj = 0;
	for (int i = pocetak; i < kraj; i++)
	{
		int polje = vodopadcina[red][i];
		if (polje < 0)
		{
			polje = 0;
		}
		broj += polje;
	}
	return broj;
}

void PadniVodu(int n, int h) 
{
	int polje;
	for (int i = 1; i <= h; i++)
	{
		for (int j = 0; j < n; j++)
		{
			polje = vodopadcina[i][j];

			if (polje >= 0)
			{
				if (vodopadcina[i - 1][j] >= 0)
				{
					vodopadcina[i][j] += vodopadcina[i - 1][j];
				}
			}
			else
			{
				int broj_vode = OdrediBrojVode(j, j - polje, i - 1);

				if (j > 0 && j - polje - 1 < n - 1)
				{
					if (broj_vode % 2 != 0)
					{
						broj_vode--;
						if (i % 2 != 0)
						{
							vodopadcina[i][j - 1]++;
						}
						else
						{
							vodopadcina[i][j - polje]++;
						}
					}

					vodopadcina[i][j - 1] += broj_vode / 2;
					vodopadcina[i][j - polje] += broj_vode / 2;
				}
				else if (j == 0) 
				{
					vodopadcina[i][j - polje] += broj_vode;
				}
				else 
				{
					vodopadcina[i][j - 1] += broj_vode;
				}

				j = j - polje - 1;
			}
		}
	}
}

void IspisiVodopad(int n, int h) 
{
	for (int j = 0; j < n; j++)
	{
		int polje = vodopadcina[h][j];
		if (polje < 0)
		{
			polje = 0;
		}
		cout << polje << " ";
	}
	cout << endl;
}

int main()
{
	int n, h;
	cin >> h;
	cin >> n;

	UcitajVodopad(n, h);

	PadniVodu(n, h);

	IspisiVodopad(n, h);
	return 0;
}