#include <iostream>
#include <string>
#include <vector>
using namespace std;

vector<vector<long long>> vodopadcina;

void GurniRedNapred(long long n) 
{
	vector <long long> red = vector <long long>();
	for (long long i = 0; i < n; i++)
	{
		red.push_back(1);
	}
	vodopadcina.push_back(red);
}

void UcitajVodopad(long long n, long long h) 
{
	GurniRedNapred(n);

	long long polje, niz_stena;
	for (long long i = 0; i < h; i++)
	{
		vector <long long> red = vector <long long>();

		niz_stena = 0;
		for (long long j = 0; j < n; j++)
		{
			cin >> polje;

			if (polje == 0) 
			{
				niz_stena++;
			}
			else
			{
				if (niz_stena > 0)
				{
					for (long long i = 0; i < niz_stena; i++)
					{
						red.push_back(-niz_stena);
					}
					niz_stena = 0;
				}
				red.push_back(0);
			}
		}

		if (niz_stena > 0)
		{
			for (long long i = 0; i < niz_stena; i++)
			{
				red.push_back(-niz_stena);
			}
		}

		vodopadcina.push_back(red);
	}
}

long long OdrediBrojVode(long long pocetak, long long kraj, long long red) 
{
	long long broj = 0;
	for (long long i = pocetak; i < kraj; i++)
	{
		long long polje = vodopadcina[red][i];
		if (polje < 0)
		{
			polje = 0;
		}
		broj += polje;
	}
	return broj;
}

void PadniVodu(long long n, long long h) 
{
	long long polje;
	for (long long i = 1; i <= h; i++)
	{
		for (long long j = 0; j < n; j++)
		{
			polje = vodopadcina[i][j];

			if (polje >= 0)
			{
				if (vodopadcina[i - 1][j] >= 0)
				{
					vodopadcina[i][j] += vodopadcina[i - 1][j];
				}
			}
			else
			{
				long long broj_vode = OdrediBrojVode(j, j - polje, i - 1);

				if (j > 0 && j - polje - 1 < n - 1)
				{
					if (broj_vode % 2 != 0)
					{
						broj_vode--;
						if (i % 2 != 0)
						{
							vodopadcina[i][j - 1]++;
						}
						else
						{
							vodopadcina[i][j - polje]++;
						}
					}

					vodopadcina[i][j - 1] += broj_vode / 2;
					vodopadcina[i][j - polje] += broj_vode / 2;
				}
				else if (j == 0) 
				{
					vodopadcina[i][j - polje] += broj_vode;
				}
				else 
				{
					vodopadcina[i][j - 1] += broj_vode;
				}

				j = j - polje - 1;
			}
		}
	}
}

void IspisiVodopad(long long n, long long h) 
{
	for (long long j = 0; j < n; j++)
	{
		long long polje = vodopadcina[h][j];
		if (polje < 0)
		{
			polje = 0;
		}
		cout << polje << " ";
	}
	cout << endl;
}

int main()
{
	long long n, h;
	cin >> h;
	cin >> n;

	UcitajVodopad(n, h);

	PadniVodu(n, h);

	IspisiVodopad(n, h);
	return 0;
}