#include <iostream>
#include <vector>
using namespace std;

// Broji koliko na levo mora da se pomeri da bi stigao na poziciju bez kamena
int levo(int j, vector<bool> red)
{
	int br = 0;
	while (j - br >= 1 && red[j - br] == 0)
		br++;
	return br;
}

// Broji koliko na desno mora da se pomeri da bi stigao na poziciju bez kamena
int desno(int j, vector<bool> red)
{
	int br = 0;
	while (j + br < red.size() - 1 && red[j + br] == 0)
		br++;
	return br;
}

int main()
{
	int h, n;
	cin >> h >> n;

	vector<int> voda(n, 1); // Popunjavamo vektor voda sa jedinicama na pocetku

	for (int i = 1; i <= h; i++)
	{
		// Ucitavamo red matrice i stavljamo ga u vektor
		vector<bool> red;
		for (int j = 0; j < n; j++)
		{
			bool a;
			cin >> a;
			red.push_back(a);
		}

		vector<int> nova_voda(voda); // Kopiramo prethodni red vode u pomocni vektor, ne smemo direktno da menjamo vektor voda
		for (int j = 0; j < n; j++)
		{
			bool a = red[j];
			if (a == 0)
			{
				if (levo(j, red) == 0) // Levo je zid, prebaci svu vodu na prvi desni slobodan
				{
					nova_voda[j + desno(j, red)] += voda[j];
				}
				else if (desno(j, red) == 0) // Desno je zid, prebaci svu vodu na prvi levi slobodan
				{
					nova_voda[j - levo(j, red)] += voda[j];
				}
				else if (voda[j] % 2 == 0) // Pola stavi na levo, pola na desno
				{
					nova_voda[j - levo(j, red)] += voda[j] / 2;
					nova_voda[j + desno(j, red)] += voda[j] / 2;
					
				}
				else if (i % 2 == 0) // Stavi jedan vise na desno
				{
					nova_voda[j - levo(j, red)] += voda[j] / 2;
					nova_voda[j + desno(j, red)] += voda[j] / 2 + 1;
				}
				else // Stavi jedan vise na levo
				{
					nova_voda[j - levo(j, red)] += voda[j] / 2 + 1;
					nova_voda[j + desno(j, red)] += voda[j] / 2;	
				}
				nova_voda[j] = 0;
			}
		}
		voda = nova_voda; // Postavljamo pokazivac vektora voda na pokazivac vektora nova_voda (u sustini postavljamo vektor voda na vektor nova_voda)
	}

	// Ispisi poslednji red vode
	for (auto a : voda)
	{
		cout << a << " ";
	}
}