#include <bits/stdc++.h>

using namespace std;


typedef vector<int> vi;


// global variables:
string V;  // V - value
bool memo[10];
int memo_values[10];

// functions:
void input();
int getNumOfBills(int cur_digit);
void output(int out);
void Solve();


int main()
{
    input();
    Solve();

    return 0;
}


int getNumOfBills(int digit) {
    if (digit == 0) {  // base case
        return 0;
    }
    if (memo[digit]) {
        return memo_values[digit];
    }
    vi bills = {1, 2, 5};
    int N = bills.size();

    for (int i = N - 1; i >= 0; --i) {
        int cur_bill =  bills[i];
        // check if it is multiple of cur bill:
        if (digit /cur_bill == 0) continue;  // move to smaller cur bill
        // add the remainders num of bills onto the current one:
        return digit / cur_bill + getNumOfBills(digit % cur_bill);
    }
    // since 0 was handled and 1 is among bills
    // return is guaranteed to execute
}

void Solve() {
    int sol = 0;  // sol - solution

    for (int i = 0; i < 10; ++i) {
        memo_values[i] = getNumOfBills(i);
        memo[i] = true;
    }

    for (int i = 0, n = V.size(); i < n; ++i) {
        int cur_digit = V[i] - '0';
        sol += memo_values[cur_digit];
    }

    output(sol);
}

void input() {
    getline(cin, V);
}

void output(int out) {
    cout << out << "\n";
}