#include <bits/stdc++.h>

using namespace std;

typedef unsigned int ui;
typedef unsigned long long ull;
typedef vector<ull> vull;

#define PB push_back


// global variables:
ull A, B;

// functions:
void Solve();
void Solve2();
vull getAllFactorsOfA();


int main()
{
    int t; scanf("%d", &t);
    while(t--) {
        Solve();
    }

    return 0;
}


vull getAllFactorsOfA(){
    vull factors;
    for (ull i = 3LL; i * i <= A; i += 2) {
        if (A % i == 0) {
            factors.PB(i);
            if(i * i != A) factors.PB(A / i);
        }
    }

    factors.PB(A);
    return factors;
}

void Solve() {  // brute force
    // A = X * Y && A % 2 = 1
    // B = X ^ Y
    scanf("%lld %lld", &A, &B);

    // since A is odd X and Y will be odd
    // B is a xor of two odd numbers, therefore an even one
    if (B & 1) {  // B is odd
        printf("-1\n");
        return;
    }

    vull factors = getAllFactorsOfA();

    ull X = 0LL, Y = 0LL;
    for (auto it = factors.begin(); it != factors.end(); it++) {
        X = *it;
        Y = A / X;
        if ((B ^ X) != Y) continue;
        printf("%lld %lld\n", X, Y);
        return;
    }
    printf("-1\n");
}

void Solve2() {
    scanf("%lld %lld", &A, &B);
    // since A is odd X and Y will be odd
    // B is a xor of two odd numbers
    if (B & 1) {  // B is odd
        printf("-1\n");
        return;
    }

    // loop through all bits of B besides
    // first since it is zero (1 xor 1)
    bitset<numeric_limits<ull>::digits> binary_B = bitset<64> (B);
    bitset<numeric_limits<ull>::digits> binary_x = bitset<64> (1ULL);  // make it odd

    vector<bitset<numeric_limits<ull>::digits>> possible_Xs = { binary_x, binary_x};
    vector<bitset<numeric_limits<ull>::digits>> possible_Ys = possible_Xs;

    // get all combinations for pairs of 0s and 1s which by xor functon give B
    ui num_of_ones_in_B = binary_B.count();
    for (ui i = 1; i < 64 && num_of_ones_in_B > 0; ++i) {
        if (!binary_B[i]) {  // current bit is 0
            possible_Xs[0][i] = possible_Ys[1][i] = 0;
            possible_Xs[1][i] = possible_Ys[1][i] = 1;
        } else {
            --num_of_ones_in_B;
            possible_Xs[0][i] = possible_Xs[1][i] = 1;
            possible_Ys[1][i] = possible_Ys[0][i] = 0;
        }
    }
    /*cout << "X1: " << possible_Xs[0].to_string() << '\n';
    cout << "Y1: " << possible_Ys[0].to_string() << '\n';
    cout << "X2: " << possible_Xs[1].to_string() << '\n';
    cout << "Y2: " << possible_Ys[1].to_string() << '\n';*/

    // check if those values work with equation in the task:
    for (ui i = 0; i < 2; ++i) {
        ull cur_X = possible_Xs[i].to_ullong();
        ull cur_Y = possible_Ys[i].to_ullong();
        printf("X: %lld; Y: %lld\n", cur_X, cur_Y, i);
        if ((cur_X * cur_Y) == A) {
            printf("%lld %lld\n", cur_X, cur_Y);
            return;
        }
    }

    printf("-1\n");  // no solutions exist
}