#include <bits/stdc++.h>

using namespace std;

typedef pair<int, int> pii;
typedef vector<pii> vpi;

#define PB push_back
#define F first
#define S second
#define MP make_pair


// global variables:
int N, A, NUM_SETS = 3;

// functions:
void input();
void Solve();
void output(vpi sets);


int main()
{
    input();
    Solve();

    return 0;
}


void Solve() {
    // make sure all 3 sets are possible:
    if (N < NUM_SETS * A || (A == 2 && N % 2 == 1)) {
        printf("-1\n");
        return;
    }

    if (N == NUM_SETS * A) {  // all points are the min needed
        for (int i = 0; i < NUM_SETS; ++i) {
            printf("%d 0\n", A);
        }
        return;
    }

    vpi sets;

    // make all but last set a A:0 score
    for (int i = 0; i < NUM_SETS - 1; ++i) {
        sets.PB(MP(A, 0));
        N -= A;  // decrease leftover points
    }

    // get rid off 1 point in order to
    // make leftover points an odd number
    if (N % 2 == 1) {
        sets[0] = MP(A, 1);
        N--;
    }

    if (N >= 2 * A) {  // e.g. 22 is left => score: 12:10
        sets.PB(MP(N / 2 + 1, N / 2 - 1));
    } else {  // e.g. 14 is left => score: 12:2
        sets.PB(MP(A, N - A));
    }

    output(sets);
}

void input() {
    scanf("%d %d", &N, &A);
}

void output(vpi sets) {
    for (auto it = sets.begin(); it != sets.end(); it++) {
        printf("%d %d\n", (*it).F, (*it).S);
    }
}