#include <bits/stdc++.h>

using namespace std;

typedef unsigned int ui;
typedef vector<ui> vui;
typedef vector<bool> vb;
typedef vector<vb> vvb;

#define PB push_back


// global variables:
vvb waterfall;
int h, w;  // h - height, w - width

// functions:
void input();
void Solve();
void output(vui out);


int main()
{
    input();
    Solve();

    return 0;
}


void Solve() {
    vui values;  // values of currentlly iterated row
    // set initial values before waterfall starts
    for (ui i = 0; i < w; ++i) {
        values.PB(1);
    }

    for (ui row = 1; row <= h; ++row) {
        ui rock_sum = 0;  // sum of values over a block of rocks
        int first_rock_idx = -1;
        for (ui col = 0; col < w; ++col) {
            if (waterfall[row][col]) {  // no rock
                if (first_rock_idx < 0) {  // nothing to change
                    continue;
                }
                if (first_rock_idx == 0) {  // add value only to current field
                    values[col] += rock_sum;
                } else {
                    // split equally
                    values[first_rock_idx - 1] += rock_sum / 2;
                    values[col] += rock_sum / 2;
                    // add 1 to the correct side if neccessary
                    if (rock_sum % 2 == 1) {
                        if (row % 2 == 0) {  // goes right
                            ++values[col];
                        } else { // goes left
                            ++values[first_rock_idx - 1];
                        }
                    }
                }

                // reset rock block values:
                rock_sum = 0;
                first_rock_idx = -1;
                continue;
            }

            if (first_rock_idx < 0) {  // check if it is a new block of rocks
                first_rock_idx = col;
            }
            rock_sum += values[col];
            values[col] = 0;  // reset value since there is no water
            // add value to the field before first rock because this
            // is the last field in the row
            if (col + 1 == w) {
                // first_rock_idx - 1 works since no row is ever full of rocks
                values[first_rock_idx - 1] += rock_sum;
            }
        }
    }

    output(values);
}

void input() {
    scanf("%d %d", &h, &w);
    vb cur_row;
    for (ui i = 0; i < w; ++i) {
        cur_row.PB(false);
    }
    waterfall.PB(cur_row);  // so it wouldn't be 0 indexed
    for (ui i = 0; i < h; ++i) {
        for (ui j = 0; j < w; ++j) {
           ui cur;
           scanf("%d", &cur);
           cur_row[j] = cur;
        }
        waterfall.PB(cur_row);
    }
}

void output(vui vct) {
    ui n = vct.size();
    for (ui i = 0; i < n - 1; ++i) {
        printf("%d ", vct[i]);
    }
    printf("%d\n", vct[n - 1]);
}