package net.pinger.takmicenje;

import java.util.Random;
import java.util.Scanner;

public class Takmicenje {


    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        int ukupno = scanner.nextInt();
        int set = scanner.nextInt();

        getCorrectScore(ukupno, set);
    }

    public static void getCorrectScore(int ukupno, int set) {
        if (set * 3 > ukupno || set == ukupno) {
            System.out.println(-1);
            return;
        }

        int count = 0;
        long counter = set;
        while (counter < ukupno && count < 5) {
            counter += set;
            count++;
        }

        int[] array = generateRandomFromValue(count, ukupno, set);
        for (int i = 0; i < array.length; i++) {
            if (array.length == 5) {
                if (i % 2 == 0) {
                    System.out.println(printCorrect(array[i], set, 0));
                } else {
                    System.out.println(printCorrect(array[i], set, 1));
                }
            } else if (array.length == 4) {
                if (i == 0) {
                    System.out.println(printCorrect(array[i], set, 0));
                } else {
                    System.out.println(printCorrect(array[i], set, 1));
                }
            } else {
                System.out.println(printCorrect(array[i], set, 0));
            }
        }
    }

    private static String printCorrect(int number, int set, int order) {
        if (number > set * 2) {
            int news = number / 2;
            if (order == 0)
               return ((news + 1) + " " + (news - 1));
            else
                return ((news - 1) + " " + (news + 1));
        } else {
            if (order == 0)
                return ((set) + " " + (number - set));
            else
                return ((number - set) + " " + (set));
        }
    }

    public static int[] generateRandomFromValue(int value, int total, int set) {
        Random rand = new Random();
        int[] arr = new int[value];

        int sum = 0;

        for (int i = 0; i < value; i++) {
            int temp = rand.nextInt((total - sum) / (value + 1)) + set;
            while (temp < set) {
                temp = rand.nextInt((total - sum) / (value + 1)) + set;
            }

            arr[i] = temp;
            sum += temp;
        }

        while (sum < total) {
            sum += 1;
            int r = rand.nextInt(arr.length);
            arr[r] += 1;

            if (isPrime(arr[r]) && sum < total) {
                arr[r] += 1;
                sum += 1;
            }
        }

        while (sum > total) {
            int r = rand.nextInt(arr.length);
            if (arr[r] > set) {
                arr[r] -= 1;
                sum -= 1;
            }
        }

        return arr;
    }

    public static boolean isPrime(int n) {
        if (n <= 1)
            return false;

        for (int i = 2; i < n; i++)
            if (n % i == 0)
                return false;

        return true;
    }



}