#include<vector>
#include<iostream>
#include<math.h>
#include<stdio.h>
#include<limits.h>

typedef unsigned long long bits;
typedef unsigned int uint;

void input(std::vector<bits>&, std::vector<bits>&);
const std::vector<bits>& get_x(const std::vector<bits>&, const std::vector<bits>&);
void output(const std::vector<bits>&, const std::vector<bits>&);

int main(){
    std::vector<bits> a;
    std::vector<bits> b;
    std::vector<bits> x;

    input(a, b);

    x = get_x(a, b);

    output(x, b);

    return 0;
}

void input(std::vector<bits>& a, std::vector<bits>& b){
    int t;
    scanf("%u", &t);
    a.resize(t);
    b.resize(t);

    for(int i = 0; i < t; ++i){
        scanf("%llu%llu", &a[i], &b[i]);
    }
}

const std::vector<bits>& get_x(const std::vector<bits>& a,
                               const std::vector<bits>& b){
    static std::vector<bits> x(a.size());

    for(uint i = 0; i < x.size(); ++i){
        x[i] = ULLONG_MAX;
        for(bits tx = 1; tx <= sqrt(a[i]); tx += 2){
            if((tx * (b[i] ^ tx)) == a[i]){
                x[i] = tx;
                break;
            }
        }
    }

    return x;
}

void output(const std::vector<bits>& x, const std::vector<bits>& b){
    for(uint i = 0; i < x.size(); ++i){
        if(x[i] != ULLONG_MAX)
            printf("%lld %lld\n", x[i], (x[i] ^ b[i]));
        else
            printf("%d\n", -1);
    }
}