//============================================================================
// Name        : gric.cpp
// Author      : Bogdan J.
//============================================================================

#include <iostream>
#include <math.h>
using namespace std;

#define MAX_GRIC    10000
#define PRECISION   12
typedef long double mer_type;

int main() {
	int w, h, r, q, tip, xi, yi, gric[2][MAX_GRIC], gric_cnt = 0;
	mer_type mer;

	cout.precision(PRECISION);
	std::cout.setf(ios::fixed, ios::floatfield);

	cin >> w >> h >> r >> q;

	for (int i = 0; i < q; i++) {

		cin >> tip;

		if (tip == 1) {
			cin >> xi >> yi;
			if (gric_cnt < MAX_GRIC) {
				gric[0][gric_cnt] = xi;
				gric[1][gric_cnt] = yi;
				++gric_cnt;
			}
		} else if (tip == 2) {
			int x;

			cin >> xi;

			mer = (mer_type) h;

			for (int j = 0; j < gric_cnt; j++) {

				x = abs(xi - gric[0][j]);

				if (x < r) {
					mer_type mer1;
					mer1 = (mer_type) gric[1][j] - (mer_type) r * sin(acos((double) x / (double) r));
					if (mer1 < mer) {
						mer = mer1;
					}
				}
			}

			cout << mer << endl;
		}
	}

	return 0;
}