#include <bits/stdc++.h>
using namespace std;

int yy[100005];
int n, seg[300005];

void init(int w) {
    int n = 1;
    while (n < w+1)
        n *= 2;
    n = n-1;
    fill(seg, seg+300005, -1);
}

int query(int pos, int x = 1, int xl = 0, int xr = n) {
    if (seg[x] != -1 || xl == xr)
        return seg[x];
    int mid = (xl+xr)/2;
    if (pos <= mid)
        return query(pos, x*2, xl, mid);
    if (pos > mid)
        return query(pos, x*2+1, mid+1, xr);
    return -1;
}

void update(int l, int r, int val, int x = 1, int xl = 0, int xr = n) {
    
    if (l > xr || r < xl)
        return;

    if (l <= xl && xr <= r) {
        seg[x] = val;
        return;
    }

    if (seg[x] != -1) {
        seg[x*2] = seg[x];
        seg[x*2+1] = seg[x];
        seg[x] = -1;
    }
    
    int mid = (xl+xr)/2;
    update(l, r, val, x*2, xl, mid);
    update(l, r, val, x*2+1, mid+1, xr);
}


signed main() {

    ios_base::sync_with_stdio(false);
    cin.tie(nullptr); cout.tie(nullptr);
    cout << fixed << setprecision(15);

    int w, h, r, q;
    cin >> w >> h >> r >> q;

    init(w);
    
    while (q--) {
        int tc; cin >> tc;
        
        if (tc == 1) {
            int x, y;
            cin >> x >> y;
            
            if (yy[x] == 0 || y < yy[x]) {
                
                yy[x] = y;
    
                int l = max(0, x-r), lh = x;
                while (l < lh) {
                    int mid = (l+lh+1)/2;
                    int xx = query(mid);
                    bool ok;
                    if (xx == -1) ok = true;
                    ok = 1.0*y-sqrt(1.0*r*r-1.0*(x-mid)*(x-mid)) < 1.0*yy[xx]-sqrt(1.0*r*r-1.0*(xx-mid)*(xx-mid));
                    if (ok) l = mid;
                    else lh = mid-1;
                }
    
    
                int d = x, dh = min(w, x+r);
                while (d < dh) {
                    int mid = (d+dh)/2;
                    int xx = query(mid);
                    bool ok;
                    if (xx == -1) ok = true;
                    else ok = 1.0*y-sqrt(1.0*r*r-1.0*(x-mid)*(x-mid)) < 1.0*yy[xx]-sqrt(1.0*r*r-1.0*(xx-mid)*(xx-mid));
                    if (ok) dh = mid;
                    else d = mid+1;
                }
    
                
                update(l, d, x);
            
            }
        }
        
        if (tc == 2) {
            int xq; cin >> xq;
            int x = query(xq);
            assert(x==-1 || yy[x]>0);
            if (x == -1)
                cout << 1.0*h << '\n';
            else
                cout << max(0.0,min(1.0*h,1.0*yy[x]-sqrt(1.0*r*r-1.0*(x-xq)*(x-xq)))) << '\n';
        }
    }
}