#include <iostream>
//#include <stdio.h>
//#include <stdlib.h>

using namespace std;

void Merge(int* a, int low, int high, int mid)
{
	// We have low to mid and mid+1 to high already sorted.
	int i, j, k, temp[high - low + 1];
	i = low;
	k = 0;
	j = mid + 1;

	// Merge the two parts into temp[].
	while (i <= mid && j <= high)
	{
		if (a[i] < a[j])
		{
			temp[k] = a[i];
			k++;
			i++;
		}
		else
		{
			temp[k] = a[j];
			k++;
			j++;
		}
	}

	// Insert all the remaining values from i to mid into temp[].
	while (i <= mid)
	{
		temp[k] = a[i];
		k++;
		i++;
	}

	// Insert all the remaining values from j to high into temp[].
	while (j <= high)
	{
		temp[k] = a[j];
		k++;
		j++;
	}


	// Assign sorted data stored in temp[] to a[].
	for (i = low; i <= high; i++)
	{
		a[i] = temp[i - low];
	}
}

void MergeSort(int* a, int low, int high)
{
	int mid;
	if (low < high)
	{
		mid = (low + high) / 2;
		// Split the data into two half.
		MergeSort(a, low, mid);
		MergeSort(a, mid + 1, high);

		// Merge them to get sorted output.
		Merge(a, low, high, mid);
	}
}

int main()
{
	long long int N = 0;
	long long int K = 0;
	int arr[100000];
	int zamena[100000];
	int zamenjivanje = 0;
	cin >> N >> K;
	for (int i = 0; i < N; i++)
	{
		cin >> arr[i];
	}

	MergeSort(arr, 0, N - 1);

	//cout << endl;
	/*for (int i = 1; i <= N; i++)
	{
		cout << arr[i] << " ";
	}*/

	for (int i = 0; i < N; i++)
	{
		int counter = 0;
		if (arr[i] == arr[i + 1])
		{
			counter = 2;
			i++;
			while (arr[i] == arr[i + 1])
			{
				counter++;
				i++;
			}
			if (counter >= K)
			{
				zamena[zamenjivanje] = arr[i];
				zamenjivanje++;
			}
		}
	}

	cout << zamenjivanje << endl;
	for (int i = 0; i < zamenjivanje; i++)
	{
		cout << zamena[i] << " ";
	}
}