#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef long double ld;

struct krug{
    ll x;
    ll y;
    ll r;
} seg[1000005];

krug dkrug;

ld eval(krug a, ll x){
    return a.y - sqrtl(a.r*a.r-(a.x-x)*(a.x-x));
}

ld query(int node, int l, int r, int x){
    ld res = eval(seg[node], x);
    if(l == r) return res;
    int mid = (l+r)/2;
    if(x <= mid) res = min(res, query(node*2, l, mid, x));
    else res = min(res, query(node*2+1, mid+1, r, x));
    return res;
}

void upd(int node, int l, int r, krug k){
    ld l1 = eval(k, l);
    ld r1 = eval(k, r);
    ld l2 = eval(seg[node], l);
    ld r2 = eval(seg[node], r);
    int mid = (l+r)/2;
    if(l1 >= l2 && r1 >= r2) return;
    if(l1 <= l2 && r1 <= r2){
        seg[node] = k;
        return;
    }
    if(l1 <= l2) upd(node*2, l, mid, k);
    if(r1 <= r2) upd(node*2+1, mid+1, r, k);
}

void init(int node, int l, int r){
    seg[node] = dkrug;
    if(l == r) return;
    int mid = (l+r)/2;
    init(node*2, l, mid);
    init(node*2+1, mid+1, r);
}

int main(){
    ios_base::sync_with_stdio(false), cin.tie(0);
    cout.precision(10);
    cout << fixed;

	int w, h, r, q;
	cin >> w >> h >> r >> q;
	w++;
	dkrug = {w, 2*(w+h), 2*w};
	init(1, 1, w);
	//cout << query(1, 1, w, 2) << endl;
	while(q--){
        int t;
        cin >> t;
        if(t == 1){
            int x, y;
            cin >> x >> y;
            x++;
            upd(1, 1, w, {x, y, r});
        }
        if(t == 2){
            int x;
            cin >> x;
            x++;
            ld res = max((ld)0, query(1, 1, w, x));
            res = min(res, (ld)h);
            cout << res << "\n";
        }
	}
    return 0;
}