#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef long double ld;

struct krug{
    ll x;
    ll y;
    ll r;
} seg[1000005];

krug dkrug;

const ll INF = 1e7;
const ll INF2 = 1e8;

ld koren(ll x){
    ld res = sqrtl(1.0*x);
    while((res+1)*(res+1) <= x) res++;
    if(res*res <= x) return res;
    while((res-1)*(res-1) >= x) res--;
    return res;
}

ld eval(krug a, ll x){
    if(a.r == 0) return INF2;
    if(a.r*a.r < (a.x-x)*(a.x-x)) return INF;
    return a.y - koren(a.r*a.r-(a.x-x)*(a.x-x));
}

ld query(int node, int l, int r, int x){
    ld res = eval(seg[node], x);
    if(l == r) return res;
    int mid = (l+r)/2;
    if(x <= mid) res = min(res, query(node*2, l, mid, x));
    else res = min(res, query(node*2+1, mid+1, r, x));
    return res;
}

bool cmpeval(krug a, krug b, int x){
    if(a.r == 0) return 0;
    if(b.r == 0) return 1;
    ll side1 = a.y-b.y;
    ll g1 = a.r*a.r-(a.x-x)*(a.x-x);
    ll g2 = b.r*b.r-(b.x-x)*(b.x-x);
    ll side22 = g1 - g2;
    if(side1 <= 0 && side22 >= 0) return 1;
    if(side1 >= 0 && side22 <= 0) return 0;
    if(side1 <= 0){
        side1 *= side1;
        ll side2 = g1+g2;
        if(side2 <= side1) return 1;
        side2 -= side1;
        side2 *= side2;
        return side2 <= 4*g1*g2;
    }
    else{
        side1 *= side1;
        ll side2 = g1+g2;
        if(side2 < side1) return 0;
        side2 -= side1;
        side2 *= side2;
        return side2 >= 4*g1*g2;
    }
}

/// logN
void upd2(int node, int l, int r, krug k){
    if(seg[node].r == 0){
        seg[node] = k;
        return;
    }
    bool t1 = cmpeval(k, seg[node], l);
    bool t2 = cmpeval(k, seg[node], r);
    int mid = (l+r)/2;
    bool t3 = cmpeval(k, seg[node], mid);
    if(!t1 && !t2) return;
    if(t1 && t2){
        seg[node] = k;
        return;
    }
    if(t1 || t3) upd2(node*2, l, mid, k);
    if(t2 || t3) upd2(node*2+1, mid+1, r, k);
}

void upd(int node, int l, int r, krug k){
    ll tl = k.x-k.r;
    ll tr = k.x+k.r;
    if(tl <= l && r <= tr){
        /// logN puta zove upd2 pa je ukupno log^2(N)
        upd2(node, l, r, k);
    }
    else if(r < tl || tr < l) return;
    else{
        int mid = (l+r)/2;
        upd(node*2, l, mid, k);
        upd(node*2+1, mid+1, r, k);
    }
}

void init(int node, int l, int r){
    seg[node] = dkrug;
    if(l == r) return;
    int mid = (l+r)/2;
    init(node*2, l, mid);
    init(node*2+1, mid+1, r);
}

int main(){
    ios_base::sync_with_stdio(false);
    cout.precision(10);
    cout << fixed;

	int w, h, r, q;
	cin >> w >> h >> r >> q;
	w++;
	dkrug = {w, 2*(w+h), 0};
	init(1, 1, w);
	while(q--){
        int t;
        cin >> t;
        if(t == 1){
            int x, y;
            cin >> x >> y;
            x++;
            upd(1, 1, w, {x, y, r});
        }
        if(t == 2){
            int x;
            cin >> x;
            x++;
            ld res1 = max((ld)0, query(1, 1, w, x));
            res1 = min(res1, (ld)h);
            cout << res1 << "\n";
        }
	}
    return 0;
}

/*
5 2 2 9
1 2 3
1 1 2
1 1 3
1 2 2
2 0
2 1
2 2
2 3
2 4
*/