#include <iostream>
#include <cmath>
#include <algorithm>
#include <iomanip>
#include <vector>
#define newl '\n'
#define print(x) cout << x << endl;
#define debug(x) cout << #x << " = " << x << endl;
#define MAXN 100005
using namespace std;

int w, h, r, q;
long double height[MAXN + 1];

struct circle
{
	int x;
	int y;
};

int main()
{
	ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
	cin >> w >> h >> r >> q;
	cout << setprecision(10);
	vector<circle> c;
	int r_sq = r * r;
	for (int i = 0; i < w + 1; i++) height[i] = (long double)h;

	if (r == 1)
	{
		while (q--)
		{
			int x;
			char cmd; cin >> cmd >> x;
			if (cmd == '1')
			{
				int y; cin >> y;
				height[x] = min(height[x], (long double)(y-1));
			}
			else //cmd = 2
			{
				cout << height[x] << newl;
			}
		}
		return 0;
	}

	if (r == 2)
	{
		const long double res1 = sqrtl(3);
		while (q--)
		{
			int x;
			char cmd; cin >> cmd >> x;
			if (cmd == '1')
			{
				int y; cin >> y;
				height[x] = min(height[x], (long double)(y - 2));
				height[x-1] = min(height[x-1], (long double)y - res1);
				height[x+1] = min(height[x+1], (long double)y - res1);
			}
			else //cmd = 2
			{
				cout << height[x] << newl;
			}
		}
		return 0;
	}

	if (q * w <= MAXN)
	{
		while (q--)
		{
			int x;
			char cmd; cin >> cmd >> x;
			if (cmd == '1')
			{
				int y; cin >> y;
				for (int i = x - r; i <= x + r; i++)
				{
					long double dist = (long double)abs(x - i);
					height[i] = min(height[i], (long double)y - sqrtl(r_sq - dist * dist));
				}
			}
			else //cmd = 2
			{
				cout << height[x] << newl;
			}
		}
		return 0;
	}

	while (q--)
	{
		int x;
		char cmd; cin >> cmd >> x;
		if (cmd == '1')
		{
			int y; cin >> y;
			if (y - r >= h || x - r >= w) continue;
			c.push_back({x, y});
		}
		else //cmd = 2
		{ 
			for (int i = 0; i < c.size(); i++)
			{
				int rx = c[i].x;
				int ry = c[i].y;
				long double dist = (long double)abs(rx-x);
				if (x > rx - r && x < rx + r)
				{
					height[x] = min(height[x], (long double)ry - sqrtl(r_sq - dist * dist));
				}
			}
			cout << height[x] << newl;
		}
	}
}